/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.util.UUID;

public final class RequestIdPolicyFactory
implements RequestPolicyFactory {
    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new RequestIdPolicy(next);
    }

    private static final class RequestIdPolicy
    implements RequestPolicy {
        private static final String REQUEST_ID_HEADER = "x-ms-client-request-id";
        private final RequestPolicy next;

        private RequestIdPolicy(RequestPolicy next) {
            this.next = next;
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            String requestId = request.headers().value(REQUEST_ID_HEADER);
            if (requestId == null) {
                request.headers().set(REQUEST_ID_HEADER, UUID.randomUUID().toString());
            }
            return this.next.sendAsync(request);
        }
    }
}

