/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.exception.locale.LocalizedFormats;
import com.mybatisflex.core.keygen.IKeyGenerator;
import com.mybatisflex.core.keygen.impl.FlexIDKeyGenerator;
import com.mybatisflex.core.keygen.impl.SnowFlakeIDKeyGenerator;
import com.mybatisflex.core.keygen.impl.UUIDKeyGenerator;
import com.mybatisflex.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class KeyGeneratorFactory {
    private static final Map<String, IKeyGenerator> KEY_GENERATOR_MAP = new HashMap<String, IKeyGenerator>();

    private KeyGeneratorFactory() {
    }

    public static IKeyGenerator getKeyGenerator(String name) {
        if (StringUtil.isBlank(name)) {
            throw FlexExceptions.wrap(LocalizedFormats.KEY_GENERATOR_BLANK, new Object[0]);
        }
        return KEY_GENERATOR_MAP.get(name.trim());
    }

    public static void register(String key, IKeyGenerator keyGenerator) {
        KEY_GENERATOR_MAP.put(key.trim(), keyGenerator);
    }

    static {
        KeyGeneratorFactory.register("uuid", new UUIDKeyGenerator());
        KeyGeneratorFactory.register("flexId", new FlexIDKeyGenerator());
        KeyGeneratorFactory.register("snowFlakeId", new SnowFlakeIDKeyGenerator());
    }
}

