/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.redis.operation;

import com.nepxion.discovery.common.redis.operation.RedisSubscribeCallback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisOperation {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private HashOperations<String, String, String> hashOperations;

    public String getConfig(String group, String serviceId) {
        return (String)this.hashOperations.get((Object)group, (Object)serviceId);
    }

    public boolean removeConfig(String group, String serviceId) {
        return this.hashOperations.delete((Object)group, new Object[]{serviceId}) == 1L;
    }

    public boolean publishConfig(String group, String serviceId, String config) {
        this.hashOperations.put((Object)group, (Object)serviceId, (Object)config);
        this.stringRedisTemplate.convertAndSend(group + "-" + serviceId, (Object)config);
        return true;
    }

    public void subscribeConfig(String config, RedisSubscribeCallback redisSubscribeCallback) {
        redisSubscribeCallback.callback(config);
    }
}

