/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.matrix.proxy.aop;

import com.nepxion.matrix.proxy.mode.ProxyMode;
import com.nepxion.matrix.proxy.mode.ScanMode;
import com.nepxion.matrix.proxy.util.ProxyUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

public abstract class AbstractAutoScanProxy
extends AbstractAutoProxyCreator {
    private static final long serialVersionUID = 6827218905375993727L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAutoScanProxy.class);
    private static final String SEPARATOR = ";";
    private final Map<String, Object> beanMap = new HashMap<String, Object>();
    private final Map<String, Boolean> proxyMap = new HashMap<String, Boolean>();
    private final Map<String, Boolean> proxyTargetClassMap = new HashMap<String, Boolean>();
    private String[] scanPackages;
    private ProxyMode proxyMode;
    private ScanMode scanMode;

    public AbstractAutoScanProxy() {
        this((String[])null);
    }

    public AbstractAutoScanProxy(String scanPackages) {
        this(scanPackages, ProxyMode.BY_CLASS_OR_METHOD_ANNOTATION, ScanMode.FOR_CLASS_OR_METHOD_ANNOTATION);
    }

    public AbstractAutoScanProxy(String[] scanPackages) {
        this(scanPackages, ProxyMode.BY_CLASS_OR_METHOD_ANNOTATION, ScanMode.FOR_CLASS_OR_METHOD_ANNOTATION);
    }

    public AbstractAutoScanProxy(ProxyMode proxyMode, ScanMode scanMode) {
        this((String[])null, proxyMode, scanMode);
    }

    public AbstractAutoScanProxy(String scanPackages, ProxyMode proxyMode, ScanMode scanMode) {
        this(scanPackages, proxyMode, scanMode, true);
    }

    public AbstractAutoScanProxy(String[] scanPackages, ProxyMode proxyMode, ScanMode scanMode) {
        this(scanPackages, proxyMode, scanMode, true);
    }

    public AbstractAutoScanProxy(ProxyMode proxyMode, ScanMode scanMode, boolean exposeProxy) {
        this((String[])null, proxyMode, scanMode, exposeProxy);
    }

    public AbstractAutoScanProxy(String scanPackages, ProxyMode proxyMode, ScanMode scanMode, boolean exposeProxy) {
        this(StringUtils.isNotEmpty((CharSequence)scanPackages) ? scanPackages.trim().split(SEPARATOR) : null, proxyMode, scanMode, exposeProxy);
    }

    public AbstractAutoScanProxy(String[] scanPackages, ProxyMode proxyMode, ScanMode scanMode, boolean exposeProxy) {
        this.scanPackages = scanPackages;
        this.setExposeProxy(exposeProxy);
        this.proxyMode = proxyMode;
        this.scanMode = scanMode;
        StringBuilder builder = new StringBuilder();
        if (ArrayUtils.isNotEmpty((Object[])scanPackages)) {
            for (int i = 0; i < scanPackages.length; ++i) {
                String scanPackage = scanPackages[i];
                builder.append(scanPackage);
                if (i >= scanPackages.length - 1) continue;
                builder.append(SEPARATOR);
            }
        }
        LOG.info("------------- Matrix Aop Information ------------");
        LOG.info("Auto scan proxy class is {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        LOG.info("Scan packages is {}", (Object)(ArrayUtils.isNotEmpty((Object[])scanPackages) ? builder.toString() : "not set"));
        LOG.info("Proxy mode is {}", (Object)proxyMode);
        LOG.info("Scan mode is {}", (Object)scanMode);
        LOG.info("Expose proxy is {}", (Object)exposeProxy);
        LOG.info("-------------------------------------------------");
        Class<? extends MethodInterceptor>[] commonInterceptorClasses = this.getCommonInterceptors();
        Object[] commonInterceptorNames = this.getCommonInterceptorNames();
        Object[] interceptorNames = (String[])ArrayUtils.addAll((Object[])commonInterceptorNames, (Object[])this.convertInterceptorNames(commonInterceptorClasses));
        if (ArrayUtils.isNotEmpty((Object[])interceptorNames)) {
            this.setInterceptorNames((String[])interceptorNames);
        }
    }

    private String[] convertInterceptorNames(Class<? extends MethodInterceptor>[] commonInterceptorClasses) {
        if (ArrayUtils.isNotEmpty((Object[])commonInterceptorClasses)) {
            String[] interceptorNames = new String[commonInterceptorClasses.length];
            for (int i = 0; i < commonInterceptorClasses.length; ++i) {
                Class<? extends MethodInterceptor> interceptorClass = commonInterceptorClasses[i];
                interceptorNames[i] = interceptorClass.getAnnotation(Component.class).value();
            }
            return interceptorNames;
        }
        return null;
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class<?> beanClass, String beanName, TargetSource targetSource) {
        boolean scanPackagesContained;
        boolean scanPackagesEnabled = this.scanPackagesEnabled();
        if (scanPackagesEnabled && !(scanPackagesContained = this.scanPackagesContained(beanClass))) {
            return DO_NOT_PROXY;
        }
        Object bean = this.beanMap.get(beanName);
        Class targetClass = null;
        targetClass = bean != null ? AopProxyUtils.ultimateTargetClass((Object)bean) : beanClass;
        if (!targetClass.isInterface()) {
            Object[] proxyInterceptors;
            if (targetClass.getInterfaces() != null) {
                for (Class<?> targetInterface : targetClass.getInterfaces()) {
                    Object[] proxyInterceptors2 = this.scanAndProxyForTarget(targetInterface, beanName, false);
                    if (proxyInterceptors2 == DO_NOT_PROXY) continue;
                    return proxyInterceptors2;
                }
            }
            if ((proxyInterceptors = this.scanAndProxyForTarget(targetClass, beanName, true)) != DO_NOT_PROXY) {
                return proxyInterceptors;
            }
        }
        return DO_NOT_PROXY;
    }

    protected Object[] scanAndProxyForTarget(Class<?> targetClass, String beanName, boolean proxyTargetClass) {
        String targetClassName = targetClass.getCanonicalName();
        Object[] interceptors = this.getInterceptors(targetClass);
        if (StringUtils.isNotEmpty((CharSequence)targetClassName) && !targetClassName.startsWith("java.")) {
            Boolean proxied = this.proxyMap.get(targetClassName);
            if (proxied != null) {
                if (proxied.booleanValue()) {
                    return interceptors;
                }
            } else {
                Object[] proxyInterceptors = null;
                switch (this.proxyMode) {
                    case BY_CLASS_ANNOTATION_ONLY: {
                        proxyInterceptors = this.scanAndProxyForClass(targetClass, targetClassName, beanName, interceptors, proxyTargetClass);
                        break;
                    }
                    case BY_METHOD_ANNOTATION_ONLY: {
                        proxyInterceptors = this.scanAndProxyForMethod(targetClass, targetClassName, beanName, interceptors, proxyTargetClass);
                        break;
                    }
                    case BY_CLASS_OR_METHOD_ANNOTATION: {
                        Object[] classProxyInterceptors = this.scanAndProxyForClass(targetClass, targetClassName, beanName, interceptors, proxyTargetClass);
                        Object[] methodProxyInterceptors = this.scanAndProxyForMethod(targetClass, targetClassName, beanName, interceptors, proxyTargetClass);
                        proxyInterceptors = classProxyInterceptors != DO_NOT_PROXY || methodProxyInterceptors != DO_NOT_PROXY ? interceptors : DO_NOT_PROXY;
                    }
                }
                this.proxyMap.put(targetClassName, proxyInterceptors != DO_NOT_PROXY);
                if (proxyInterceptors != DO_NOT_PROXY) {
                    Object[] commonInterceptorNames;
                    this.proxyTargetClassMap.put(beanName, proxyTargetClass);
                    LOG.info("------------ Matrix Proxy Information -----------");
                    Object[] commonInterceptorClasses = this.getCommonInterceptors();
                    if (ArrayUtils.isNotEmpty((Object[])commonInterceptorClasses)) {
                        LOG.info("Class [{}] is proxied by common interceptor classes [{}], proxyTargetClass={}", new Object[]{targetClassName, ProxyUtil.toString(commonInterceptorClasses), proxyTargetClass});
                    }
                    if (ArrayUtils.isNotEmpty((Object[])(commonInterceptorNames = this.getCommonInterceptorNames()))) {
                        LOG.info("Class [{}] is proxied by common interceptor beans [{}], proxyTargetClass={}", new Object[]{targetClassName, ProxyUtil.toString((String[])commonInterceptorNames), proxyTargetClass});
                    }
                    if (proxyInterceptors != PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS && ArrayUtils.isNotEmpty((Object[])proxyInterceptors)) {
                        LOG.info("Class [{}] is proxied by additional interceptors [{}], proxyTargetClass={}", new Object[]{targetClassName, proxyInterceptors, proxyTargetClass});
                    }
                    LOG.info("-------------------------------------------------");
                }
                return proxyInterceptors;
            }
        }
        return DO_NOT_PROXY;
    }

    protected Object[] scanAndProxyForClass(Class<?> targetClass, String targetClassName, String beanName, Object[] interceptors, boolean proxyTargetClass) {
        boolean proxied = false;
        Object[] classAnnotations = this.getClassAnnotations();
        if (ArrayUtils.isNotEmpty((Object[])classAnnotations)) {
            for (Object classAnnotation : classAnnotations) {
                if (!targetClass.isAnnotationPresent((Class<Annotation>)classAnnotation)) continue;
                if (this.scanMode != ScanMode.FOR_CLASS_ANNOTATION_ONLY && this.scanMode != ScanMode.FOR_CLASS_OR_METHOD_ANNOTATION) {
                    return interceptors;
                }
                this.classAnnotationScanned(targetClass, (Class<? extends Annotation>)classAnnotation);
                if (proxied) continue;
                proxied = true;
            }
        }
        return proxied ? interceptors : DO_NOT_PROXY;
    }

    protected Object[] scanAndProxyForMethod(Class<?> targetClass, String targetClassName, String beanName, Object[] interceptors, boolean proxyTargetClass) {
        boolean proxied = false;
        Object[] methodAnnotations = this.getMethodAnnotations();
        if (ArrayUtils.isNotEmpty((Object[])methodAnnotations)) {
            for (Method method : targetClass.getDeclaredMethods()) {
                for (Object methodAnnotation : methodAnnotations) {
                    if (!method.isAnnotationPresent((Class<? extends Annotation>)methodAnnotation)) continue;
                    if (this.scanMode != ScanMode.FOR_METHOD_ANNOTATION_ONLY && this.scanMode != ScanMode.FOR_CLASS_OR_METHOD_ANNOTATION) {
                        return interceptors;
                    }
                    this.methodAnnotationScanned(targetClass, method, (Class<? extends Annotation>)methodAnnotation);
                    if (proxied) continue;
                    proxied = true;
                }
            }
        }
        return proxied ? interceptors : DO_NOT_PROXY;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Object object = super.postProcessBeforeInitialization(bean, beanName);
        boolean scanPackagesEnabled = this.scanPackagesEnabled();
        if (scanPackagesEnabled) {
            boolean scanPackagesContained = this.scanPackagesContained(bean.getClass());
            if (scanPackagesContained) {
                this.beanMap.put(beanName, bean);
            }
        } else {
            this.beanMap.put(beanName, bean);
        }
        return object;
    }

    protected boolean shouldProxyTargetClass(Class<?> beanClass, String beanName) {
        Boolean proxyTargetClass = this.proxyTargetClassMap.get(beanName);
        if (proxyTargetClass != null) {
            return proxyTargetClass;
        }
        return super.shouldProxyTargetClass(beanClass, beanName);
    }

    protected boolean scanPackagesEnabled() {
        return ArrayUtils.isNotEmpty((Object[])this.scanPackages);
    }

    protected boolean scanPackagesContained(Class<?> beanClass) {
        for (String scanPackage : this.scanPackages) {
            String beanClassName;
            if (!StringUtils.isNotEmpty((CharSequence)scanPackage) || !StringUtils.isNotEmpty((CharSequence)(beanClassName = beanClass.getCanonicalName())) || !beanClassName.startsWith(scanPackage)) continue;
            return true;
        }
        return false;
    }

    protected Object[] getInterceptors(Class<?> targetClass) {
        Object[] interceptors = this.getAdditionalInterceptors(targetClass);
        if (ArrayUtils.isNotEmpty((Object[])interceptors)) {
            return interceptors;
        }
        Object[] commonInterceptorClasses = this.getCommonInterceptors();
        Object[] commonInterceptorNames = this.getCommonInterceptorNames();
        if (ArrayUtils.isNotEmpty((Object[])commonInterceptorClasses) || ArrayUtils.isNotEmpty((Object[])commonInterceptorNames)) {
            return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        return DO_NOT_PROXY;
    }

    protected abstract Class<? extends MethodInterceptor>[] getCommonInterceptors();

    protected abstract String[] getCommonInterceptorNames();

    protected abstract MethodInterceptor[] getAdditionalInterceptors(Class<?> var1);

    protected abstract Class<? extends Annotation>[] getClassAnnotations();

    protected abstract Class<? extends Annotation>[] getMethodAnnotations();

    protected abstract void classAnnotationScanned(Class<?> var1, Class<? extends Annotation> var2);

    protected abstract void methodAnnotationScanned(Class<?> var1, Method var2, Class<? extends Annotation> var3);

    static {
        System.out.println("");
        System.out.println("\u2554\u2550\u2557\u2554\u2550\u2557   \u2554\u2557");
        System.out.println("\u2551\u2551\u255a\u255d\u2551\u2551  \u2554\u255d\u255a\u2557");
        System.out.println("\u2551\u2554\u2557\u2554\u2557\u2560\u2550\u2550\u256c\u2557\u2554\u256c\u2550\u2566\u2566\u2557\u2554\u2557");
        System.out.println("\u2551\u2551\u2551\u2551\u2551\u2551\u2554\u2557\u2551\u2551\u2551\u2551\u2554\u256c\u256c\u256c\u256c\u255d");
        System.out.println("\u2551\u2551\u2551\u2551\u2551\u2551\u2554\u2557\u2551\u2551\u255a\u2563\u2551\u2551\u2560\u256c\u256c\u2557");
        System.out.println("\u255a\u255d\u255a\u255d\u255a\u2569\u255d\u255a\u255d\u255a\u2550\u2569\u255d\u255a\u2569\u255d\u255a\u255d");
        System.out.println("Nepxion Matrix - AutoScanProxy  v2.0.1");
        System.out.println("");
    }
}

