/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.PropertyWrapper;
import com.netflix.governator.configuration.AbstractObjectConfigurationProvider;
import com.netflix.governator.configuration.ConfigurationKey;
import com.netflix.governator.configuration.ConfigurationOwnershipPolicies;
import com.netflix.governator.configuration.ConfigurationOwnershipPolicy;
import com.netflix.governator.configuration.DateWithDefaultSupplier;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.codehaus.jackson.map.ObjectMapper;

public class ArchaiusConfigurationProvider
extends AbstractObjectConfigurationProvider {
    private final Map<String, String> variableValues;
    private final AbstractConfiguration configurationManager;
    private final DynamicPropertyFactory propertyFactory;
    private final ConfigurationOwnershipPolicy ownershipPolicy;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public ArchaiusConfigurationProvider() {
        this(new HashMap<String, String>());
    }

    @Deprecated
    public ArchaiusConfigurationProvider(Map<String, String> variableValues) {
        this.variableValues = Maps.newHashMap(variableValues);
        this.configurationManager = ConfigurationManager.getConfigInstance();
        this.propertyFactory = DynamicPropertyFactory.getInstance();
        this.ownershipPolicy = new ConfigurationOwnershipPolicy(){

            @Override
            public boolean has(ConfigurationKey key, Map<String, String> variables) {
                return ArchaiusConfigurationProvider.this.configurationManager.containsKey(key.getKey(variables));
            }
        };
    }

    private ArchaiusConfigurationProvider(Builder builder) {
        super(builder.objectMapper);
        this.variableValues = builder.variableValues;
        this.configurationManager = builder.configurationManager;
        this.propertyFactory = builder.propertyFactory;
        this.ownershipPolicy = builder.ownershipPolicy;
    }

    protected static Supplier<?> getDynamicSupplier(Class<?> type, String key, String defaultValue, DynamicPropertyFactory propertyFactory) {
        if (type.isAssignableFrom(String.class)) {
            return new PropertyWrapperSupplier(propertyFactory.getStringProperty(key, defaultValue));
        }
        if (type.isAssignableFrom(Integer.class)) {
            return new PropertyWrapperSupplier(propertyFactory.getIntProperty(key, defaultValue == null ? 0 : Integer.parseInt(defaultValue)));
        }
        if (type.isAssignableFrom(Double.class)) {
            return new PropertyWrapperSupplier(propertyFactory.getDoubleProperty(key, defaultValue == null ? 0.0 : Double.parseDouble(defaultValue)));
        }
        if (type.isAssignableFrom(Long.class)) {
            return new PropertyWrapperSupplier(propertyFactory.getLongProperty(key, defaultValue == null ? 0L : Long.parseLong(defaultValue)));
        }
        if (type.isAssignableFrom(Boolean.class)) {
            return new PropertyWrapperSupplier(propertyFactory.getBooleanProperty(key, defaultValue == null ? false : Boolean.parseBoolean(defaultValue)));
        }
        throw new RuntimeException("Unsupported value type " + type.getCanonicalName());
    }

    public void setVariable(String name, String value) {
        this.variableValues.put(name, value);
    }

    @Override
    public boolean has(ConfigurationKey key) {
        return this.ownershipPolicy.has(key, this.variableValues);
    }

    @Override
    public Supplier<Boolean> getBooleanSupplier(ConfigurationKey key, Boolean defaultValue) {
        return new PropertyWrapperSupplier<Boolean>((PropertyWrapper<Boolean>)this.propertyFactory.getBooleanProperty(key.getKey(this.variableValues), defaultValue.booleanValue()));
    }

    @Override
    public Supplier<Integer> getIntegerSupplier(ConfigurationKey key, Integer defaultValue) {
        return new PropertyWrapperSupplier<Integer>((PropertyWrapper<Integer>)this.propertyFactory.getIntProperty(key.getKey(this.variableValues), defaultValue.intValue()));
    }

    @Override
    public Supplier<Long> getLongSupplier(ConfigurationKey key, Long defaultValue) {
        return new PropertyWrapperSupplier<Long>((PropertyWrapper<Long>)this.propertyFactory.getLongProperty(key.getKey(this.variableValues), defaultValue.longValue()));
    }

    @Override
    public Supplier<Double> getDoubleSupplier(ConfigurationKey key, Double defaultValue) {
        return new PropertyWrapperSupplier<Double>((PropertyWrapper<Double>)this.propertyFactory.getDoubleProperty(key.getKey(this.variableValues), defaultValue.doubleValue()));
    }

    @Override
    public Supplier<String> getStringSupplier(ConfigurationKey key, String defaultValue) {
        return new PropertyWrapperSupplier<String>((PropertyWrapper<String>)this.propertyFactory.getStringProperty(key.getKey(this.variableValues), defaultValue));
    }

    @Override
    public Supplier<Date> getDateSupplier(ConfigurationKey key, Date defaultValue) {
        return new DateWithDefaultSupplier(this.getStringSupplier(key, null), defaultValue);
    }

    public static class PropertyWrapperSupplier<T>
    implements Supplier<T> {
        private final PropertyWrapper<T> wrapper;

        public PropertyWrapperSupplier(PropertyWrapper<T> wrapper) {
            this.wrapper = wrapper;
        }

        public T get() {
            return (T)this.wrapper.getValue();
        }
    }

    public static class Builder {
        private Map<String, String> variableValues = Maps.newHashMap();
        private AbstractConfiguration configurationManager = ConfigurationManager.getConfigInstance();
        private DynamicPropertyFactory propertyFactory = DynamicPropertyFactory.getInstance();
        private ConfigurationOwnershipPolicy ownershipPolicy = ConfigurationOwnershipPolicies.ownsAll();
        private ObjectMapper objectMapper = new ObjectMapper();

        public Builder withVariableValues(Map<String, String> variableValues) {
            this.variableValues = variableValues;
            return this;
        }

        public Builder withConfigurationManager(AbstractConfiguration configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public Builder withPropertyFactory(DynamicPropertyFactory propertyFactory) {
            this.propertyFactory = propertyFactory;
            return this;
        }

        public Builder withOwnershipPolicy(ConfigurationOwnershipPolicy policy) {
            this.ownershipPolicy = policy;
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public ArchaiusConfigurationProvider build() {
            if (this.ownershipPolicy == null) {
                this.ownershipPolicy = new ConfigurationOwnershipPolicy(){

                    @Override
                    public boolean has(ConfigurationKey key, Map<String, String> variables) {
                        return Builder.this.configurationManager.containsKey(key.getKey(Builder.this.variableValues));
                    }
                };
            }
            return new ArchaiusConfigurationProvider(this);
        }

        private Builder() {
        }
    }
}

