/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.netflix.governator.configuration.AbstractObjectConfigurationProvider;
import com.netflix.governator.configuration.ConfigurationKey;
import com.netflix.governator.configuration.DateWithDefaultSupplier;
import java.util.Date;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class SystemConfigurationProvider
extends AbstractObjectConfigurationProvider {
    private final Map<String, String> variableValues;

    public SystemConfigurationProvider() {
        this(Maps.newHashMap());
    }

    public SystemConfigurationProvider(Map<String, String> variableValues) {
        this(variableValues, null);
    }

    public SystemConfigurationProvider(Map<String, String> variableValues, ObjectMapper objectMapper) {
        super(objectMapper);
        this.variableValues = Maps.newHashMap(variableValues);
    }

    public void setVariable(String name, String value) {
        this.variableValues.put(name, value);
    }

    @Override
    public boolean has(ConfigurationKey key) {
        return System.getProperty(key.getKey(this.variableValues), null) != null;
    }

    @Override
    public Supplier<Boolean> getBooleanSupplier(final ConfigurationKey key, final Boolean defaultValue) {
        return new Supplier<Boolean>(){

            public Boolean get() {
                String value = System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues));
                if (value == null) {
                    return defaultValue;
                }
                return Boolean.parseBoolean(value);
            }
        };
    }

    @Override
    public Supplier<Integer> getIntegerSupplier(final ConfigurationKey key, final Integer defaultValue) {
        return new Supplier<Integer>(){

            public Integer get() {
                Integer value;
                try {
                    value = Integer.parseInt(System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues)));
                }
                catch (NumberFormatException ex) {
                    return defaultValue;
                }
                return value;
            }
        };
    }

    @Override
    public Supplier<Long> getLongSupplier(final ConfigurationKey key, final Long defaultValue) {
        return new Supplier<Long>(){

            public Long get() {
                Long value;
                try {
                    value = Long.parseLong(System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues)));
                }
                catch (NumberFormatException ex) {
                    return defaultValue;
                }
                return value;
            }
        };
    }

    @Override
    public Supplier<Double> getDoubleSupplier(final ConfigurationKey key, final Double defaultValue) {
        return new Supplier<Double>(){

            public Double get() {
                Double value;
                try {
                    value = Double.parseDouble(System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues)));
                }
                catch (NumberFormatException ex) {
                    return defaultValue;
                }
                return value;
            }
        };
    }

    @Override
    public Supplier<String> getStringSupplier(final ConfigurationKey key, final String defaultValue) {
        return new Supplier<String>(){

            public String get() {
                String value = System.getProperty(key.getKey(SystemConfigurationProvider.this.variableValues));
                if (value == null) {
                    return defaultValue;
                }
                return value;
            }
        };
    }

    @Override
    public Supplier<Date> getDateSupplier(ConfigurationKey key, Date defaultValue) {
        return new DateWithDefaultSupplier(this.getStringSupplier(key, null), defaultValue);
    }
}

