/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.AnnotatedConstantBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.Message;
import com.google.inject.spi.TypeConverter;
import com.google.inject.spi.TypeListener;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.lifecycle.LifecycleListener;
import com.netflix.governator.lifecycle.ResourceLocator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapBinder
implements Binder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Binder binder;

    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        this.binder.bindInterceptor(classMatcher, methodMatcher, interceptors);
    }

    public void bindScope(Class<? extends Annotation> annotationType, Scope scope) {
        this.binder.bindScope(annotationType, scope);
    }

    public LinkedBindingBuilder<LifecycleListener> bindLifecycleListener() {
        return Multibinder.newSetBinder((Binder)this.binder, LifecycleListener.class).addBinding();
    }

    public LinkedBindingBuilder<ResourceLocator> bindResourceLocator() {
        return Multibinder.newSetBinder((Binder)this.binder, ResourceLocator.class).addBinding();
    }

    public LinkedBindingBuilder<ConfigurationProvider> bindConfigurationProvider() {
        return Multibinder.newSetBinder((Binder)this.binder, ConfigurationProvider.class).addBinding();
    }

    public <T> LinkedBindingBuilder<T> bind(Key<T> key) {
        this.warnOnSpecialized(key.getTypeLiteral().getRawType());
        return this.binder.bind(key);
    }

    public <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        this.warnOnSpecialized(typeLiteral.getRawType());
        return this.binder.bind(typeLiteral);
    }

    public <T> AnnotatedBindingBuilder<T> bind(Class<T> type) {
        this.warnOnSpecialized(type);
        return this.binder.bind(type);
    }

    public AnnotatedConstantBindingBuilder bindConstant() {
        return this.binder.bindConstant();
    }

    public <T> void requestInjection(TypeLiteral<T> type, T instance) {
        this.binder.requestInjection(type, instance);
    }

    public void requestInjection(Object instance) {
        this.binder.requestInjection(instance);
    }

    public void requestStaticInjection(Class<?> ... types) {
        this.binder.requestStaticInjection((Class[])types);
    }

    public void install(Module module) {
        this.binder.install(module);
    }

    public Stage currentStage() {
        return this.binder.currentStage();
    }

    public void addError(String message, Object ... arguments) {
        this.binder.addError(message, arguments);
    }

    public void addError(Throwable t) {
        this.binder.addError(t);
    }

    public void addError(Message message) {
        this.binder.addError(message);
    }

    public <T> Provider<T> getProvider(Key<T> key) {
        return this.binder.getProvider(key);
    }

    public <T> Provider<T> getProvider(Class<T> type) {
        return this.binder.getProvider(type);
    }

    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        return this.binder.getMembersInjector(typeLiteral);
    }

    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.binder.getMembersInjector(type);
    }

    public void convertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
        this.binder.convertToTypes(typeMatcher, converter);
    }

    public void bindListener(Matcher<? super TypeLiteral<?>> typeMatcher, TypeListener listener) {
        this.binder.bindListener(typeMatcher, listener);
    }

    public Binder withSource(Object source) {
        return this.binder.withSource(source);
    }

    public Binder skipSources(Class ... classesToSkip) {
        return this.binder.skipSources(classesToSkip);
    }

    public PrivateBinder newPrivateBinder() {
        return this.binder.newPrivateBinder();
    }

    public void requireExplicitBindings() {
        this.binder.requireExplicitBindings();
    }

    public void disableCircularProxies() {
        this.binder.disableCircularProxies();
    }

    BootstrapBinder(Binder binder) {
        this.binder = binder;
    }

    private <T> void warnOnSpecialized(Class<T> clazz) {
        if (ConfigurationProvider.class.isAssignableFrom(clazz)) {
            this.log.warn("You should use the specialized binding method for ConfigurationProviders");
        }
        if (LifecycleListener.class.isAssignableFrom(clazz)) {
            this.log.warn("You should use the specialized binding method for LifecycleListener");
        }
        if (ResourceLocator.class.isAssignableFrom(clazz)) {
            this.log.warn("You should use the specialized binding method for ResourceLocator");
        }
    }
}

