/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.io.Closeables;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.grapher.GrapherModule;
import com.google.inject.grapher.InjectorGrapher;
import com.google.inject.grapher.graphviz.GraphvizModule;
import com.google.inject.grapher.graphviz.GraphvizRenderer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;

public class Grapher {
    private final Injector injector;

    @Inject
    public Grapher(Injector injector) {
        this.injector = injector;
    }

    public String toFile() throws Exception {
        File file = File.createTempFile("GuiceDependencies_", ".dot");
        this.toFile(file);
        return file.getCanonicalPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFile(File file) throws Exception {
        PrintWriter out = new PrintWriter(file, "UTF-8");
        try {
            out.write(this.graph());
        }
        finally {
            Closeables.closeQuietly((Closeable)out);
        }
    }

    public String graph() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        Injector localInjector = Guice.createInjector((Module[])new Module[]{new GrapherModule(), new GraphvizModule()});
        GraphvizRenderer renderer = (GraphvizRenderer)localInjector.getInstance(GraphvizRenderer.class);
        renderer.setOut(out).setRankdir("TB");
        ((InjectorGrapher)localInjector.getInstance(InjectorGrapher.class)).of(this.injector).graph();
        return this.fixupGraph(baos.toString("UTF-8"));
    }

    private String fixupGraph(String s) {
        s = this.fixGrapherBug(s);
        s = this.hideClassPaths(s);
        return s;
    }

    private String hideClassPaths(String s) {
        s = s.replaceAll("\\w[a-z\\d_\\.]+\\.([A-Z][A-Za-z\\d_]*)", "");
        s = s.replaceAll("value=[\\w-]+", "random");
        return s;
    }

    private String fixGrapherBug(String s) {
        s = s.replaceAll("style=invis", "style=solid");
        return s;
    }
}

