/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Types;
import com.netflix.governator.annotations.AutoBind;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.guice.AutoBindProvider;
import com.netflix.governator.guice.ProviderBinderUtil;
import com.netflix.governator.lifecycle.ClasspathScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;

class InternalAutoBindModule
extends AbstractModule {
    private final List<Class<?>> ignoreClasses;
    private final Injector injector;
    private final ClasspathScanner classpathScanner;

    InternalAutoBindModule(Injector injector, ClasspathScanner classpathScanner, Collection<Class<?>> ignoreClasses) {
        this.injector = injector;
        this.classpathScanner = classpathScanner;
        Preconditions.checkNotNull(ignoreClasses, (Object)"ignoreClasses cannot be null");
        this.ignoreClasses = ImmutableList.copyOf(ignoreClasses);
    }

    protected void configure() {
        this.bindAutoBindSingletons();
        this.bindAutoBindConstructors();
        this.bindAutoBindMethods();
        this.bindAutoBindFields();
    }

    private void bindAutoBindFields() {
        for (Field field : this.classpathScanner.getFields()) {
            if (this.ignoreClasses.contains(field.getDeclaringClass())) continue;
            this.bindAnnotations(field.getDeclaredAnnotations());
        }
    }

    private void bindAutoBindMethods() {
        for (Method method : this.classpathScanner.getMethods()) {
            if (this.ignoreClasses.contains(method.getDeclaringClass())) continue;
            this.bindParameterAnnotations(method.getParameterAnnotations());
        }
    }

    private void bindAutoBindConstructors() {
        for (Constructor constructor : this.classpathScanner.getConstructors()) {
            if (this.ignoreClasses.contains(constructor.getDeclaringClass())) continue;
            this.bindParameterAnnotations(constructor.getParameterAnnotations());
        }
    }

    private void bindParameterAnnotations(Annotation[][] parameterAnnotations) {
        for (Annotation[] annotations : parameterAnnotations) {
            this.bindAnnotations(annotations);
        }
    }

    private void bindAnnotations(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            AutoBindProvider autoBindProvider = this.getAutoBindProvider(annotation);
            if (autoBindProvider == null) continue;
            autoBindProvider.configure(this.binder(), annotation);
        }
    }

    private AutoBindProvider getAutoBindProvider(Annotation annotation) {
        AutoBindProvider autoBindProvider = null;
        if (annotation.annotationType().isAnnotationPresent(AutoBind.class)) {
            ParameterizedType parameterizedType = Types.newParameterizedType(AutoBindProvider.class, (Type[])new Type[]{annotation.annotationType()});
            autoBindProvider = (AutoBindProvider)this.injector.getInstance(Key.get((TypeLiteral)TypeLiteral.get((Type)parameterizedType)));
        } else if (annotation.annotationType().isAssignableFrom(AutoBind.class)) {
            autoBindProvider = (AutoBindProvider)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<AutoBindProvider<AutoBind>>(){}));
        }
        return autoBindProvider;
    }

    private void bindAutoBindSingletons() {
        for (Class<?> clazz : this.classpathScanner.getClasses()) {
            if (this.ignoreClasses.contains(clazz) || !clazz.isAnnotationPresent(AutoBindSingleton.class)) continue;
            AutoBindSingleton annotation = clazz.getAnnotation(AutoBindSingleton.class);
            if (Provider.class.isAssignableFrom(clazz)) {
                Preconditions.checkState((annotation.value() == AutoBindSingleton.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for Providers");
                Preconditions.checkState((annotation.baseClass() == AutoBindSingleton.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for Providers");
                Preconditions.checkState((!annotation.multiple() ? 1 : 0) != 0, (Object)"@AutoBindSingleton(multiple=true) value cannot be set for Providers");
                ProviderBinderUtil.bind(this.binder(), clazz, Scopes.SINGLETON);
                continue;
            }
            if (Module.class.isAssignableFrom(clazz)) {
                Preconditions.checkState((annotation.value() == AutoBindSingleton.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for Modules");
                Preconditions.checkState((annotation.baseClass() == AutoBindSingleton.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for Modules");
                Preconditions.checkState((!annotation.multiple() ? 1 : 0) != 0, (Object)"@AutoBindSingleton(multiple=true) value cannot be set for Modules");
                Class<?> moduleClass = clazz;
                Module module = (Module)this.injector.getInstance(moduleClass);
                this.binder().install(module);
                continue;
            }
            this.bindAutoBindSingleton(annotation, clazz);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bindAutoBindSingleton(AutoBindSingleton annotation, Class<?> clazz) {
        Class<?> annotationBaseClass = this.getAnnotationBaseClass(annotation);
        if (annotationBaseClass != AutoBindSingleton.class) {
            Object foundBindingClass = this.searchForBaseClass(clazz, annotationBaseClass, Sets.newHashSet());
            if (foundBindingClass == null) {
                throw new IllegalArgumentException(String.format("AutoBindSingleton class %s does not implement or extend %s", clazz.getName(), annotationBaseClass.getName()));
            }
            if (foundBindingClass instanceof Class) {
                if (annotation.multiple()) {
                    Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), (Class)((Class)foundBindingClass));
                    multibinder.addBinding().to(clazz).asEagerSingleton();
                    return;
                } else {
                    this.binder().bind((Class)foundBindingClass).to(clazz).asEagerSingleton();
                }
                return;
            } else {
                if (!(foundBindingClass instanceof Type)) throw new RuntimeException("Unexpected binding class: " + foundBindingClass);
                TypeLiteral typeLiteral = TypeLiteral.get((Type)((Type)foundBindingClass));
                if (annotation.multiple()) {
                    Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)typeLiteral);
                    multibinder.addBinding().to(clazz).asEagerSingleton();
                    return;
                } else {
                    this.binder().bind(typeLiteral).to(clazz).asEagerSingleton();
                }
            }
            return;
        } else {
            Preconditions.checkState((!annotation.multiple() ? 1 : 0) != 0, (Object)"@AutoBindSingleton(multiple=true) must have either value or baseClass set");
            this.binder().bind(clazz).asEagerSingleton();
        }
    }

    private Class<?> getAnnotationBaseClass(AutoBindSingleton annotation) {
        Class<?> annotationValue = annotation.value();
        Class<?> annotationBaseClass = annotation.baseClass();
        Preconditions.checkState((annotationValue == AutoBindSingleton.class || annotationBaseClass == AutoBindSingleton.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton cannot have both value and baseClass set");
        return annotationBaseClass != AutoBindSingleton.class ? annotationBaseClass : annotationValue;
    }

    private Object searchForBaseClass(Class<?> clazz, Class<?> annotationBaseClass, Set<Object> usedSet) {
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(annotationBaseClass)) {
            return clazz;
        }
        if (!usedSet.add(clazz)) {
            return null;
        }
        for (Type type : clazz.getGenericInterfaces()) {
            if (!MoreTypes.getRawType((Type)type).equals(annotationBaseClass)) continue;
            return type;
        }
        if (clazz.getGenericSuperclass() != null && MoreTypes.getRawType((Type)clazz.getGenericSuperclass()).equals(annotationBaseClass)) {
            return clazz.getGenericSuperclass();
        }
        for (Type type : clazz.getInterfaces()) {
            Object foundBindingClass = this.searchForBaseClass((Class<?>)type, annotationBaseClass, usedSet);
            if (foundBindingClass == null) continue;
            return foundBindingClass;
        }
        return this.searchForBaseClass(clazz.getSuperclass(), annotationBaseClass, usedSet);
    }
}

