/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.lazy.FineGrainedLazySingleton;
import com.netflix.governator.guice.lazy.FineGrainedLazySingletonScope;
import com.netflix.governator.guice.lazy.LazySingleton;
import com.netflix.governator.guice.lazy.LazySingletonScope;
import com.netflix.governator.lifecycle.ClasspathScanner;
import com.netflix.governator.lifecycle.LifecycleConfigurationProviders;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.util.List;
import java.util.Set;

class InternalBootstrapModule
extends AbstractModule {
    private final ClasspathScanner scanner;
    private BootstrapBinder bootstrapBinder;
    private final List<BootstrapModule> bootstrapModules;

    InternalBootstrapModule(ClasspathScanner scanner, List<BootstrapModule> bootstrapModules) {
        this.scanner = scanner;
        this.bootstrapModules = ImmutableList.copyOf(bootstrapModules);
    }

    BootstrapBinder getBootstrapBinder() {
        return this.bootstrapBinder;
    }

    protected void configure() {
        this.bind(ConfigurationDocumentation.class).in(Scopes.SINGLETON);
        this.bindScope(LazySingleton.class, LazySingletonScope.get());
        this.bindScope(FineGrainedLazySingleton.class, FineGrainedLazySingletonScope.get());
        this.bootstrapBinder = new BootstrapBinder(this.binder());
        if (this.bootstrapModules != null) {
            for (BootstrapModule bootstrapModule : this.bootstrapModules) {
                bootstrapModule.configure(this.bootstrapBinder);
            }
        }
        this.bindLoaders(this.bootstrapBinder);
        this.binder().bind(LifecycleManager.class).asEagerSingleton();
        this.binder().bind(LifecycleConfigurationProviders.class).toProvider(LifecycleConfigurationProvidersProvider.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    public ClasspathScanner getClasspathScanner() {
        return this.scanner;
    }

    private void bindLoaders(BootstrapBinder binder) {
        for (Class<?> clazz : this.scanner.getClasses()) {
            if (!clazz.isAnnotationPresent(AutoBindSingleton.class) || !ConfigurationProvider.class.isAssignableFrom(clazz)) continue;
            AutoBindSingleton annotation = clazz.getAnnotation(AutoBindSingleton.class);
            Preconditions.checkState((annotation.value() == AutoBindSingleton.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for ConfigurationProviders");
            Preconditions.checkState((annotation.baseClass() == AutoBindSingleton.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for ConfigurationProviders");
            Preconditions.checkState((!annotation.multiple() ? 1 : 0) != 0, (Object)"@AutoBindSingleton(multiple=true) value cannot be set for ConfigurationProviders");
            Class<?> configurationProviderClass = clazz;
            binder.bindConfigurationProvider().to(configurationProviderClass).asEagerSingleton();
        }
    }

    private static class LifecycleConfigurationProvidersProvider
    implements Provider<LifecycleConfigurationProviders> {
        @Inject(optional=true)
        private Set<ConfigurationProvider> configurationProviders = Sets.newHashSet();

        private LifecycleConfigurationProvidersProvider() {
        }

        public LifecycleConfigurationProviders get() {
            return new LifecycleConfigurationProviders(this.configurationProviders);
        }
    }
}

