/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.List;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalModuleDependencyModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(InternalModuleDependencyModule.class);
    private final List<Module> modules = Lists.newArrayList();
    private static final String GUICE_PACKAGE_PREFX = "com.google.inject";
    private static final String GOVERNATOR_PACKAGE_PREFIX = "com.netflix.governator.guice";

    protected void configure() {
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                if (Module.class.isAssignableFrom(type.getRawType())) {
                    encounter.register(new InjectionListener<I>(){

                        public void afterInjection(I injectee) {
                            if (null == injectee.getClass().getAnnotation(com.google.inject.Singleton.class) && null == injectee.getClass().getAnnotation(Singleton.class)) {
                                LOG.info("Ignore module dependency : " + injectee.getClass().getCanonicalName() + " Module not @Singleton");
                                return;
                            }
                            if (injectee.getClass().getCanonicalName().startsWith(InternalModuleDependencyModule.GUICE_PACKAGE_PREFX)) {
                                LOG.info("Ignore module dependency : " + injectee.getClass().getCanonicalName() + " Internal modules are skipped");
                                return;
                            }
                            LOG.info("Found module dependency : " + injectee.getClass().getCanonicalName());
                            InternalModuleDependencyModule.this.modules.add((Module)injectee);
                        }
                    });
                }
            }
        });
    }

    public List<Module> getModules() {
        return ImmutableList.copyOf(this.modules);
    }
}

