/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Stage;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.InternalAutoBindModule;
import com.netflix.governator.guice.InternalBootstrapModule;
import com.netflix.governator.guice.InternalLifecycleModule;
import com.netflix.governator.guice.InternalModuleDependencyModule;
import com.netflix.governator.guice.LifecycleInjectorBuilder;
import com.netflix.governator.guice.LifecycleInjectorBuilderImpl;
import com.netflix.governator.guice.LifecycleInjectorMode;
import com.netflix.governator.guice.lazy.FineGrainedLazySingleton;
import com.netflix.governator.guice.lazy.FineGrainedLazySingletonScope;
import com.netflix.governator.guice.lazy.LazySingleton;
import com.netflix.governator.guice.lazy.LazySingletonScope;
import com.netflix.governator.lifecycle.ClasspathScanner;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.Resources;

public class LifecycleInjector {
    private final ClasspathScanner scanner;
    private final List<Module> modules;
    private final Collection<Class<?>> ignoreClasses;
    private final boolean ignoreAllClasses;
    private final LifecycleManager lifecycleManager;
    private final Injector injector;
    private final BootstrapBinder bootstrapBinder;
    private final Stage stage;
    private final LifecycleInjectorMode mode;
    private final List<Module> discoveredModules = Lists.newArrayList();

    public static LifecycleInjectorBuilder builder() {
        return new LifecycleInjectorBuilderImpl();
    }

    public static ClasspathScanner createStandardClasspathScanner(Collection<String> basePackages) {
        return LifecycleInjector.createStandardClasspathScanner(basePackages, null);
    }

    public static ClasspathScanner createStandardClasspathScanner(Collection<String> basePackages, List<Class<? extends Annotation>> additionalAnnotations) {
        ArrayList annotations = Lists.newArrayList();
        annotations.add(AutoBindSingleton.class);
        annotations.add(Inject.class);
        annotations.add(javax.inject.Inject.class);
        annotations.add(Resource.class);
        annotations.add(Resources.class);
        if (additionalAnnotations != null) {
            annotations.addAll(additionalAnnotations);
        }
        return new ClasspathScanner(basePackages, annotations);
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public Injector createChildInjector(Module ... modules) {
        return this.createChildInjector(Arrays.asList(modules));
    }

    public Injector createChildInjector(Collection<Module> modules) {
        if (this.mode == LifecycleInjectorMode.REAL_CHILD_INJECTORS) {
            return this.injector.createChildInjector(modules);
        }
        return this.createSimulatedChildInjector(modules);
    }

    public Injector createInjector() {
        return this.createInjector(Lists.newArrayList());
    }

    public Injector createInjector(Module ... modules) {
        return this.createInjector(Arrays.asList(modules));
    }

    public Injector createInjector(Collection<Module> additionalModules) {
        ArrayList localModules = Lists.newArrayList(this.discoveredModules);
        if (additionalModules != null) {
            localModules.addAll(additionalModules);
        }
        localModules.addAll(this.modules);
        if (!this.ignoreAllClasses) {
            HashSet localIgnoreClasses = Sets.newHashSet(this.ignoreClasses);
            localModules.add(new InternalAutoBindModule(this.injector, this.scanner, localIgnoreClasses));
        }
        return this.createChildInjector(localModules);
    }

    LifecycleInjector(List<Module> modules, Collection<Class<?>> ignoreClasses, boolean ignoreAllClasses, List<BootstrapModule> bootstrapModules, ClasspathScanner scanner, Collection<String> basePackages, Stage stage, LifecycleInjectorMode mode, List<Class<? extends Module>> moduleClasses) {
        this.mode = (LifecycleInjectorMode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode cannot be null"));
        this.stage = (Stage)Preconditions.checkNotNull((Object)stage, (Object)"stage cannot be null");
        this.ignoreAllClasses = ignoreAllClasses;
        this.ignoreClasses = ImmutableList.copyOf(ignoreClasses);
        this.modules = ImmutableList.copyOf(modules);
        this.scanner = scanner != null ? scanner : LifecycleInjector.createStandardClasspathScanner(basePackages);
        InternalModuleDependencyModule moduleDepdencyModule = new InternalModuleDependencyModule();
        AtomicReference<LifecycleManager> lifecycleManagerRef = new AtomicReference<LifecycleManager>();
        InternalBootstrapModule internalBootstrapModule = new InternalBootstrapModule(this.scanner, bootstrapModules);
        this.injector = Guice.createInjector((Stage)stage, (Module[])new Module[]{internalBootstrapModule, new InternalLifecycleModule(lifecycleManagerRef), moduleDepdencyModule});
        for (Class<? extends Module> moduleClass : moduleClasses) {
            this.injector.getInstance(moduleClass);
        }
        this.discoveredModules.addAll(moduleDepdencyModule.getModules());
        this.lifecycleManager = (LifecycleManager)this.injector.getInstance(LifecycleManager.class);
        lifecycleManagerRef.set(this.lifecycleManager);
        this.bootstrapBinder = internalBootstrapModule.getBootstrapBinder();
    }

    private Injector createSimulatedChildInjector(Collection<Module> modules) {
        AbstractModule parentObjects = new AbstractModule(){

            protected void configure() {
                Map bindings = LifecycleInjector.this.injector.getAllBindings();
                for (Map.Entry binding : bindings.entrySet()) {
                    Class cls = ((Key)binding.getKey()).getTypeLiteral().getRawType();
                    if (Module.class.isAssignableFrom(cls) || Injector.class.isAssignableFrom(cls) || Stage.class.isAssignableFrom(cls) || Logger.class.isAssignableFrom(cls)) continue;
                    Provider provider = ((Binding)binding.getValue()).getProvider();
                    this.bind((Key)binding.getKey()).toProvider(provider);
                }
                this.bindScope(LazySingleton.class, LazySingletonScope.get());
                this.bindScope(FineGrainedLazySingleton.class, FineGrainedLazySingletonScope.get());
            }
        };
        AtomicReference<LifecycleManager> lifecycleManagerAtomicReference = new AtomicReference<LifecycleManager>(this.lifecycleManager);
        InternalLifecycleModule internalLifecycleModule = new InternalLifecycleModule(lifecycleManagerAtomicReference);
        ArrayList localModules = Lists.newArrayList(modules);
        localModules.add(parentObjects);
        localModules.add(internalLifecycleModule);
        return Guice.createInjector((Stage)this.stage, (Iterable)localModules);
    }
}

