/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.LifecycleInjector;
import com.netflix.governator.guice.LifecycleInjectorBuilder;
import com.netflix.governator.guice.LifecycleInjectorMode;
import com.netflix.governator.lifecycle.ClasspathScanner;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

class LifecycleInjectorBuilderImpl
implements LifecycleInjectorBuilder {
    private List<Module> modules = Lists.newArrayList();
    private Collection<Class<?>> ignoreClasses = Lists.newArrayList();
    private Collection<String> basePackages = Lists.newArrayList();
    private boolean ignoreAllClasses = false;
    private List<BootstrapModule> bootstrapModules = Lists.newArrayList();
    private ClasspathScanner scanner = null;
    private Stage stage = Stage.PRODUCTION;
    private LifecycleInjectorMode mode = LifecycleInjectorMode.REAL_CHILD_INJECTORS;
    private List<Class<? extends Module>> moduleClasses = ImmutableList.of();

    @Override
    public LifecycleInjectorBuilder withBootstrapModule(BootstrapModule module) {
        this.bootstrapModules = ImmutableList.of((Object)module);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalBootstrapModules(BootstrapModule ... additionalBootstrapModules) {
        return this.withAdditionalBootstrapModules((Iterable<? extends BootstrapModule>)ImmutableList.copyOf((Object[])additionalBootstrapModules));
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalBootstrapModules(Iterable<? extends BootstrapModule> additionalBootstrapModules) {
        this.bootstrapModules = ImmutableList.builder().addAll(this.bootstrapModules).addAll(additionalBootstrapModules).build();
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModules(Module ... modules) {
        this.modules = ImmutableList.copyOf((Object[])modules);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModules(Iterable<? extends Module> modules) {
        this.modules = ImmutableList.copyOf(modules);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalModules(Iterable<? extends Module> additionalModules) {
        this.modules = ImmutableList.builder().addAll(this.modules).addAll(additionalModules).build();
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalModules(Module ... modules) {
        return this.withAdditionalModules((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    @Override
    public LifecycleInjectorBuilder withRootModule(Class<?> rootModule) {
        return this.withModuleClass(rootModule);
    }

    @Override
    public LifecycleInjectorBuilder withModuleClass(Class<? extends Module> module) {
        this.moduleClasses = ImmutableList.of(module);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModuleClasses(Iterable<Class<? extends Module>> modules) {
        this.moduleClasses = ImmutableList.copyOf(modules);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModuleClasses(Class<? extends Module> ... modules) {
        this.moduleClasses = ImmutableList.copyOf((Object[])modules);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalModuleClasses(Iterable<Class<? extends Module>> modules) {
        this.moduleClasses = ImmutableList.builder().addAll(this.moduleClasses).addAll(modules).build();
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalModuleClasses(Class<? extends Module> ... modules) {
        this.moduleClasses = ImmutableList.builder().addAll(this.moduleClasses).addAll((Iterable)Lists.newArrayList((Object[])modules)).build();
        return this;
    }

    @Override
    public LifecycleInjectorBuilder ignoringAutoBindClasses(Collection<Class<?>> ignoreClasses) {
        this.ignoreClasses = ImmutableList.copyOf(ignoreClasses);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder ignoringAllAutoBindClasses() {
        this.ignoreAllClasses = true;
        return this;
    }

    @Override
    public LifecycleInjectorBuilder usingBasePackages(String ... basePackages) {
        return this.usingBasePackages(Arrays.asList(basePackages));
    }

    @Override
    public LifecycleInjectorBuilder usingBasePackages(Collection<String> basePackages) {
        this.basePackages = Lists.newArrayList(basePackages);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder usingClasspathScanner(ClasspathScanner scanner) {
        this.scanner = scanner;
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withMode(LifecycleInjectorMode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public LifecycleInjectorBuilder inStage(Stage stage) {
        this.stage = stage;
        return this;
    }

    @Override
    public LifecycleInjector build() {
        return new LifecycleInjector(this.modules, this.ignoreClasses, this.ignoreAllClasses, this.bootstrapModules, this.scanner, this.basePackages, this.stage, this.mode, this.moduleClasses);
    }

    @Override
    @Deprecated
    public Injector createInjector() {
        return this.build().createInjector();
    }

    LifecycleInjectorBuilderImpl() {
    }
}

