/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.governator.lifecycle.GovernatorFileArchive;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanner {
    private static final Logger log = LoggerFactory.getLogger(ClasspathScanner.class);
    private final ClassLoader classLoader;
    private final Set<Class<?>> classes;
    private final Set<Constructor> constructors;
    private final Set<Method> methods;
    private final Set<Field> fields;

    public ClasspathScanner(Collection<String> basePackages, Collection<Class<? extends Annotation>> annotations) {
        this(basePackages, annotations, Thread.currentThread().getContextClassLoader());
    }

    public ClasspathScanner(Collection<String> basePackages, Collection<Class<? extends Annotation>> annotations, ClassLoader classLoader) {
        Preconditions.checkNotNull(annotations, (Object)"additionalAnnotations cannot be null");
        Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader cannot be null");
        log.debug("Starting classpath scanning...");
        this.classLoader = classLoader;
        HashSet localClasses = Sets.newHashSet();
        HashSet localConstructors = Sets.newHashSet();
        HashSet localMethods = Sets.newHashSet();
        HashSet localFields = Sets.newHashSet();
        if (basePackages.size() == 0) {
            log.warn("No base packages specified - no classpath scanning will be done");
        } else {
            this.doScanning(basePackages, annotations, localClasses, localConstructors, localMethods, localFields);
        }
        this.classes = ImmutableSet.copyOf((Collection)localClasses);
        this.constructors = ImmutableSet.copyOf((Collection)localConstructors);
        this.methods = ImmutableSet.copyOf((Collection)localMethods);
        this.fields = ImmutableSet.copyOf((Collection)localFields);
        log.debug("Classpath scanning done");
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Constructor> getConstructors() {
        return this.constructors;
    }

    public Set<Method> getMethods() {
        return this.methods;
    }

    public Set<Field> getFields() {
        return this.fields;
    }

    private void doScanning(Collection<String> basePackages, Collection<Class<? extends Annotation>> annotations, Set<Class<?>> localClasses, Set<Constructor> localConstructors, Set<Method> localMethods, Set<Field> localFields) {
        try {
            ArrayList archives = Lists.newArrayList();
            for (String basePackage : basePackages) {
                Enumeration<URL> resources = this.classLoader.getResources(basePackage.replace(".", "/"));
                while (resources.hasMoreElements()) {
                    URL thisUrl = resources.nextElement();
                    if (this.isJarURL(thisUrl)) {
                        archives.add(new JarArchive(this.classLoader, thisUrl));
                        continue;
                    }
                    archives.add(new GovernatorFileArchive(this.classLoader, thisUrl, basePackage));
                }
                CompositeArchive compositeArchive = new CompositeArchive((Iterable)archives);
                AnnotationFinder annotationFinder = new AnnotationFinder((Archive)compositeArchive);
                for (Class<? extends Annotation> annotation : annotations) {
                    localClasses.addAll(annotationFinder.findAnnotatedClasses(annotation));
                    localConstructors.addAll(annotationFinder.findAnnotatedConstructors(annotation));
                    localMethods.addAll(annotationFinder.findAnnotatedMethods(annotation));
                    localFields.addAll(annotationFinder.findAnnotatedFields(annotation));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return "zip".equals(protocol) || "jar".equals(protocol);
    }
}

