/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.collect.Maps;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.annotations.ConfigurationVariable;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationMapper;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.lifecycle.ConfigurationProcessor;
import com.netflix.governator.lifecycle.LifecycleMethods;
import java.lang.reflect.Field;
import java.util.HashMap;

public class DefaultConfigurationMapper
implements ConfigurationMapper {
    @Override
    public void mapConfiguration(ConfigurationProvider configurationProvider, ConfigurationDocumentation configurationDocumentation, Object obj, LifecycleMethods methods) throws Exception {
        HashMap overrides = Maps.newHashMap();
        for (Field variableField : methods.fieldsFor(ConfigurationVariable.class)) {
            ConfigurationVariable annot = variableField.getAnnotation(ConfigurationVariable.class);
            if (annot == null) continue;
            overrides.put(annot.name(), variableField.get(obj).toString());
        }
        ConfigurationProcessor configurationProcessor = new ConfigurationProcessor(configurationProvider, configurationDocumentation);
        for (Field configurationField : methods.fieldsFor(Configuration.class)) {
            configurationProcessor.assignConfiguration(obj, configurationField, overrides);
        }
    }
}

