/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.netflix.governator.annotations.PreConfiguration;
import com.netflix.governator.configuration.ConfigurationColumnWriter;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationMapper;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.lifecycle.LifecycleListener;
import com.netflix.governator.lifecycle.LifecycleManagerArguments;
import com.netflix.governator.lifecycle.LifecycleMethods;
import com.netflix.governator.lifecycle.LifecycleState;
import com.netflix.governator.lifecycle.PostStartArguments;
import com.netflix.governator.lifecycle.ResourceLocator;
import com.netflix.governator.lifecycle.ValidationException;
import com.netflix.governator.lifecycle.warmup.DAGManager;
import com.netflix.governator.lifecycle.warmup.WarmUpDriver;
import com.netflix.governator.lifecycle.warmup.WarmUpSession;
import java.beans.Introspector;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.naming.NamingException;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LifecycleManager
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<StateKey, LifecycleState> objectStates = Maps.newConcurrentMap();
    private final List<PreDestroyRecord> preDestroys = new CopyOnWriteArrayList<PreDestroyRecord>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final ConfigurationDocumentation configurationDocumentation;
    private final ConfigurationProvider configurationProvider;
    private final ConfigurationMapper configurationMapper;
    private final Collection<LifecycleListener> listeners;
    private final Collection<ResourceLocator> resourceLocators;
    private final ValidatorFactory factory;
    private final DAGManager dagManager = new DAGManager();
    private final PostStartArguments postStartArguments;
    private final AtomicReference<WarmUpSession> postStartWarmUpSession = new AtomicReference<Object>(null);
    private final Injector injector;

    public LifecycleManager() {
        this(new LifecycleManagerArguments(), null);
    }

    public LifecycleManager(LifecycleManagerArguments arguments) {
        this(arguments, null);
    }

    @Inject
    public LifecycleManager(LifecycleManagerArguments arguments, Injector injector) {
        this.injector = injector;
        this.configurationMapper = arguments.getConfigurationMapper();
        this.listeners = ImmutableSet.copyOf(arguments.getLifecycleListeners());
        this.resourceLocators = ImmutableSet.copyOf(arguments.getResourceLocators());
        this.factory = Validation.buildDefaultValidatorFactory();
        this.postStartArguments = arguments.getPostStartArguments();
        this.configurationDocumentation = arguments.getConfigurationDocumentation();
        this.configurationProvider = arguments.getConfigurationProvider();
    }

    public Collection<LifecycleListener> getListeners() {
        return this.listeners;
    }

    public void add(Object ... objects) throws Exception {
        for (Object obj : objects) {
            this.add(obj);
        }
    }

    public void add(Object obj) throws Exception {
        this.add(obj, new LifecycleMethods(obj.getClass()));
    }

    public void add(Object obj, LifecycleMethods methods) throws Exception {
        Preconditions.checkState((this.state.get() != State.CLOSED ? 1 : 0) != 0, (Object)"LifecycleManager is closed");
        this.startInstance(obj, methods);
        if (this.hasStarted()) {
            this.initializeObjectPostStart(obj);
        }
    }

    public boolean hasStarted() {
        return this.state.get() == State.STARTED;
    }

    public LifecycleState getState(Object obj) {
        LifecycleState lifecycleState = this.objectStates.get(new StateKey(obj));
        if (lifecycleState == null) {
            lifecycleState = this.hasStarted() ? LifecycleState.ACTIVE : LifecycleState.LATENT;
        }
        return lifecycleState;
    }

    public void start() throws Exception {
        this.start(0L, null);
    }

    public boolean start(long maxWait, TimeUnit unit) throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTING), (Object)"Already started");
        this.validate();
        long maxMs = unit != null ? unit.toMillis(maxWait) : Long.MAX_VALUE;
        WarmUpSession warmUpSession = new WarmUpSession(this.getWarmUpDriver(), this.dagManager);
        boolean success = warmUpSession.doImmediate(maxMs);
        new ConfigurationColumnWriter(this.configurationDocumentation).output(this.log);
        this.state.set(State.STARTED);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.state.compareAndSet(State.STARTING, State.CLOSED) || this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            try {
                this.stopInstances();
            }
            catch (Exception e) {
                this.log.error("While stopping instances", (Throwable)e);
            }
            finally {
                this.preDestroys.clear();
                this.objectStates.clear();
            }
        }
    }

    public void validate() throws ValidationException {
        ValidationException exception = null;
        Validator validator = this.factory.getValidator();
        for (StateKey key : this.objectStates.keySet()) {
            Object obj = key.obj;
            exception = this.internalValidateObject(exception, obj, validator);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void validate(Object obj) throws ValidationException {
        Validator validator = this.factory.getValidator();
        ValidationException exception = this.internalValidateObject(null, obj, validator);
        if (exception != null) {
            throw exception;
        }
    }

    public DAGManager getDAGManager() {
        return this.dagManager;
    }

    private void setState(Object obj, LifecycleState state) {
        this.objectStates.put(new StateKey(obj), state);
        for (LifecycleListener listener : this.listeners) {
            listener.stateChanged(obj, state);
        }
    }

    private ValidationException internalValidateObject(ValidationException exception, Object obj, Validator validator) {
        Set violations = validator.validate(obj, new Class[0]);
        for (ConstraintViolation violation : violations) {
            String path = this.getPath((ConstraintViolation<Object>)violation);
            String message = String.format("%s - %s.%s = %s", violation.getMessage(), obj.getClass().getName(), path, String.valueOf(violation.getInvalidValue()));
            if (exception == null) {
                exception = new ValidationException(message);
                continue;
            }
            exception = new ValidationException(message, exception);
        }
        return exception;
    }

    private void startInstance(Object obj, LifecycleMethods methods) throws Exception {
        this.log.debug(String.format("Starting %s", obj.getClass().getName()));
        this.setState(obj, LifecycleState.PRE_CONFIGURATION);
        for (Method preConfiguration : methods.methodsFor(PreConfiguration.class)) {
            this.log.debug(String.format("\t%s()", preConfiguration.getName()));
            preConfiguration.invoke(obj, new Object[0]);
        }
        this.setState(obj, LifecycleState.SETTING_CONFIGURATION);
        this.configurationMapper.mapConfiguration(this.configurationProvider, this.configurationDocumentation, obj, methods);
        this.setState(obj, LifecycleState.SETTING_RESOURCES);
        this.setResources(obj, methods);
        this.setState(obj, LifecycleState.POST_CONSTRUCTING);
        for (Method postConstruct : methods.methodsFor(PostConstruct.class)) {
            this.log.debug(String.format("\t%s()", postConstruct.getName()));
            postConstruct.invoke(obj, new Object[0]);
        }
        Collection<Method> preDestroyMethods = methods.methodsFor(PreDestroy.class);
        if (preDestroyMethods.size() > 0) {
            this.preDestroys.add(new PreDestroyRecord(obj, preDestroyMethods));
        }
    }

    private void setResources(Object obj, LifecycleMethods methods) throws Exception {
        Resource resource;
        Resources resources;
        for (Field field : methods.fieldsFor(Resources.class)) {
            resources = field.getAnnotation(Resources.class);
            for (Resource resource2 : resources.value()) {
                this.setFieldResource(obj, field, resource2);
            }
        }
        for (Field field : methods.fieldsFor(Resource.class)) {
            resource = field.getAnnotation(Resource.class);
            this.setFieldResource(obj, field, resource);
        }
        for (Method method : methods.methodsFor(Resources.class)) {
            resources = method.getAnnotation(Resources.class);
            for (Resource resource2 : resources.value()) {
                this.setMethodResource(obj, method, resource2);
            }
        }
        for (Method method : methods.methodsFor(Resource.class)) {
            resource = method.getAnnotation(Resource.class);
            this.setMethodResource(obj, method, resource);
        }
        for (Resources resources2 : methods.classAnnotationsFor(Resources.class)) {
            for (Resource resource3 : resources2.value()) {
                this.loadClassResource(resource3);
            }
        }
        for (Resource resource4 : methods.classAnnotationsFor(Resource.class)) {
            this.loadClassResource(resource4);
        }
    }

    private void loadClassResource(Resource resource) throws Exception {
        if (resource.name().length() == 0 || resource.type() == Object.class) {
            throw new Exception("Class resources must have both name() and type(): " + resource);
        }
        this.findResource(resource);
    }

    private void setMethodResource(Object obj, Method method, Resource resource) throws Exception {
        if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) {
            throw new Exception(String.format("%s.%s() is not a proper JavaBean setter.", obj.getClass().getName(), method.getName()));
        }
        String beanName = method.getName();
        if (beanName.toLowerCase().startsWith("set")) {
            beanName = beanName.substring("set".length());
        }
        beanName = Introspector.decapitalize(beanName);
        String siteName = obj.getClass().getName() + "/" + beanName;
        resource = this.adjustResource(resource, method.getParameterTypes()[0], siteName);
        Object resourceObj = this.findResource(resource);
        method.setAccessible(true);
        method.invoke(obj, resourceObj);
    }

    private void setFieldResource(Object obj, Field field, Resource resource) throws Exception {
        String siteName = obj.getClass().getName() + "/" + field.getName();
        Object resourceObj = this.findResource(this.adjustResource(resource, field.getType(), siteName));
        field.setAccessible(true);
        field.set(obj, resourceObj);
    }

    private Resource adjustResource(final Resource resource, final Class siteType, final String siteName) {
        return new Resource(){

            public String name() {
                return resource.name().length() == 0 ? siteName : resource.name();
            }

            public Class type() {
                return resource.type() == Object.class ? siteType : resource.type();
            }

            public Resource.AuthenticationType authenticationType() {
                return resource.authenticationType();
            }

            public boolean shareable() {
                return resource.shareable();
            }

            public String mappedName() {
                return resource.mappedName();
            }

            public String description() {
                return resource.description();
            }

            public Class<? extends Annotation> annotationType() {
                return resource.annotationType();
            }
        };
    }

    private Object findResource(Resource resource) throws Exception {
        if (this.resourceLocators.size() > 0) {
            final Iterator<ResourceLocator> iterator = this.resourceLocators.iterator();
            ResourceLocator locator = iterator.next();
            ResourceLocator nextInChain = new ResourceLocator(){

                @Override
                public Object locate(Resource resource, ResourceLocator nextInChain) throws Exception {
                    if (iterator.hasNext()) {
                        return ((ResourceLocator)iterator.next()).locate(resource, this);
                    }
                    return LifecycleManager.this.defaultFindResource(resource);
                }
            };
            return locator.locate(resource, nextInChain);
        }
        return this.defaultFindResource(resource);
    }

    private Object defaultFindResource(Resource resource) throws Exception {
        if (this.injector == null) {
            throw new NamingException("Could not find resource: " + resource);
        }
        return this.injector.getInstance(resource.type());
    }

    private void stopInstances() throws Exception {
        for (PreDestroyRecord record : this.getReversed(this.preDestroys)) {
            this.log.debug(String.format("Stopping %s:%d", record.obj.getClass().getName(), System.identityHashCode(record.obj)));
            this.setState(record.obj, LifecycleState.PRE_DESTROYING);
            for (Method preDestroy : record.preDestroyMethods) {
                this.log.debug(String.format("\t%s()", preDestroy.getName()));
                try {
                    preDestroy.invoke(record.obj, new Object[0]);
                }
                catch (Throwable e) {
                    this.log.error("Couldn't stop lifecycle managed instance", e);
                }
            }
            this.objectStates.remove(new StateKey(record.obj));
        }
    }

    private List<PreDestroyRecord> getReversed(List<PreDestroyRecord> records) {
        ArrayList reversed = Lists.newArrayList(records);
        Collections.reverse(reversed);
        return reversed;
    }

    private String getPath(ConstraintViolation<Object> violation) {
        Iterable transformed = Iterables.transform((Iterable)violation.getPropertyPath(), (Function)new Function<Path.Node, String>(){

            public String apply(Path.Node node) {
                return node.getName();
            }
        });
        return Joiner.on((String)".").join(transformed);
    }

    private void initializeObjectPostStart(Object obj) throws ValidationException {
        this.validate(obj);
        this.postStartWarmUpSession.compareAndSet(null, new WarmUpSession(this.getWarmUpDriver(), this.dagManager));
        WarmUpSession session = this.postStartWarmUpSession.get();
        session.doInBackground();
    }

    private WarmUpDriver getWarmUpDriver() {
        return new WarmUpDriver(){

            @Override
            public void setPreWarmUpState() {
                for (StateKey key : LifecycleManager.this.objectStates.keySet()) {
                    LifecycleManager.this.objectStates.put(key, LifecycleState.PRE_WARMING_UP);
                }
            }

            @Override
            public void setPostWarmUpState() {
                Iterator iterator = LifecycleManager.this.objectStates.values().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() == LifecycleState.ERROR) continue;
                    iterator.remove();
                }
            }

            @Override
            public PostStartArguments getPostStartArguments() {
                return LifecycleManager.this.postStartArguments;
            }

            @Override
            public void setState(Object obj, LifecycleState state) {
                LifecycleManager.this.setState(obj, state);
            }
        };
    }

    private static class PreDestroyRecord {
        final Object obj;
        final Collection<Method> preDestroyMethods;

        private PreDestroyRecord(Object obj, Collection<Method> preDestroyMethods) {
            this.obj = obj;
            this.preDestroyMethods = preDestroyMethods;
        }
    }

    private static class StateKey {
        final Object obj;

        private StateKey(Object obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.hashCode() == o.hashCode();
        }
    }

    private static enum State {
        LATENT,
        STARTING,
        STARTED,
        CLOSED;

    }
}

