/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle.warmup;

import com.google.common.collect.Maps;
import com.netflix.governator.lifecycle.warmup.DAGManager;
import com.netflix.governator.lifecycle.warmup.WarmUpDriver;
import com.netflix.governator.lifecycle.warmup.WarmUpErrors;
import com.netflix.governator.lifecycle.warmup.WarmUpException;
import com.netflix.governator.lifecycle.warmup.WarmUpTask;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;

public class WarmUpSession {
    private final ForkJoinPool forkJoinPool = new ForkJoinPool();
    private final WarmUpDriver warmUpDriver;
    private final DAGManager dagManager;
    private boolean isPaddingInBackground = false;

    public WarmUpSession(WarmUpDriver warmUpDriver, DAGManager dagManager) {
        this.warmUpDriver = warmUpDriver;
        this.dagManager = dagManager;
    }

    public boolean doImmediate(long maxMs) throws Exception {
        this.warmUpDriver.setPreWarmUpState();
        WarmUpErrors errors = new WarmUpErrors();
        WarmUpTask rootTask = this.newRootTask(errors);
        this.forkJoinPool.submit((ForkJoinTask)rootTask);
        this.forkJoinPool.shutdown();
        boolean success = this.forkJoinPool.awaitTermination(maxMs, TimeUnit.MILLISECONDS);
        if (!success) {
            this.forkJoinPool.shutdownNow();
        }
        errors.throwIfErrors();
        this.warmUpDriver.setPostWarmUpState();
        return success;
    }

    public synchronized void doInBackground() {
        if (!this.isPaddingInBackground) {
            this.isPaddingInBackground = true;
            this.forkJoinPool.submit((ForkJoinTask)this.newBackgroundAction());
        }
    }

    private WarmUpTask newRootTask(WarmUpErrors errors) {
        DAGManager copy = this.dagManager.newCopyAndClear();
        ConcurrentMap tasks = Maps.newConcurrentMap();
        return new WarmUpTask(this.warmUpDriver, errors, copy, tasks);
    }

    private RecursiveAction newBackgroundAction() {
        return new RecursiveAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void compute() {
                WarmUpTask rootTask;
                WarmUpErrors errors;
                try {
                    Thread.sleep(WarmUpSession.this.warmUpDriver.getPostStartArguments().getWarmUpPaddingMs());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                WarmUpSession warmUpSession = WarmUpSession.this;
                synchronized (warmUpSession) {
                    errors = new WarmUpErrors();
                    rootTask = WarmUpSession.this.newRootTask(errors);
                    WarmUpSession.this.isPaddingInBackground = false;
                }
                rootTask.compute();
                try {
                    errors.throwIfErrors();
                }
                catch (WarmUpException e) {
                    WarmUpSession.this.warmUpDriver.getPostStartArguments().getWarmUpErrorHandler().warmUpError(e);
                }
                WarmUpSession.this.warmUpDriver.setPostWarmUpState();
            }
        };
    }
}

