/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle.warmup;

import com.google.common.collect.Lists;
import com.netflix.governator.annotations.WarmUp;
import com.netflix.governator.lifecycle.LifecycleMethods;
import com.netflix.governator.lifecycle.LifecycleState;
import com.netflix.governator.lifecycle.warmup.DAGManager;
import com.netflix.governator.lifecycle.warmup.DependencyNode;
import com.netflix.governator.lifecycle.warmup.WarmUpDriver;
import com.netflix.governator.lifecycle.warmup.WarmUpErrors;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import jsr166y.RecursiveAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarmUpTask
extends RecursiveAction {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConcurrentMap<Object, WarmUpTask> tasks;
    private final boolean isRoot;
    private final WarmUpDriver warmUpDriver;
    private final WarmUpErrors errors;
    private final DAGManager dagManager;
    private final DependencyNode node;

    public WarmUpTask(WarmUpDriver warmUpDriver, WarmUpErrors errors, DAGManager dagManager, ConcurrentMap<Object, WarmUpTask> tasks) {
        this(warmUpDriver, errors, dagManager, dagManager.buildTree(), tasks, true);
    }

    private WarmUpTask(WarmUpDriver warmUpDriver, WarmUpErrors errors, DAGManager dagManager, DependencyNode node, ConcurrentMap<Object, WarmUpTask> tasks, boolean isRoot) {
        this.warmUpDriver = warmUpDriver;
        this.errors = errors;
        this.dagManager = dagManager;
        this.node = node;
        this.tasks = tasks;
        this.isRoot = isRoot;
    }

    protected void compute() {
        ArrayList childTasks = Lists.newArrayList();
        for (DependencyNode child : this.node.getChildren()) {
            WarmUpTask newChildTask = new WarmUpTask(this.warmUpDriver, this.errors, this.dagManager, child, this.tasks, false);
            WarmUpTask existingChildTask = this.tasks.putIfAbsent(child.getKey(), newChildTask);
            if (existingChildTask == null) {
                newChildTask.fork();
                childTasks.add(newChildTask);
                continue;
            }
            childTasks.add(existingChildTask);
        }
        for (WarmUpTask task : childTasks) {
            task.join();
        }
        if (!this.isRoot) {
            this.warmUpObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warmUpObject() {
        Object obj = this.dagManager.getObject(this.node.getKey());
        if (obj == null) {
            this.log.debug(String.format("Could not find lifecycle-registered object for key. Ignoring object. Key: %s - KeyClass: %s", this.node.getKey(), this.node.getKey().getClass().getName()));
        } else {
            this.warmUpDriver.setState(obj, LifecycleState.WARMING_UP);
            LifecycleMethods lifecycleMethods = this.dagManager.getLifecycleMethods(this.node.getKey());
            Collection<Method> methods = lifecycleMethods != null ? lifecycleMethods.methodsFor(WarmUp.class) : null;
            LifecycleState newState = LifecycleState.ACTIVE;
            try {
                if (methods != null) {
                    for (Method method : methods) {
                        method.invoke(obj, new Object[0]);
                    }
                }
            }
            catch (Throwable e) {
                String message = String.format("Key: %s - Object: %s", this.node.getKey(), obj.getClass().getName());
                e = this.errors.addError(e, message);
                this.log.error("Error warming up object. " + message, e);
                newState = LifecycleState.ERROR;
            }
            finally {
                this.warmUpDriver.setState(obj, newState);
            }
        }
    }
}

