/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.netflix.servo.Metric;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.PollCallable;
import com.netflix.servo.util.UnmodifiableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeMetricPoller
implements MetricPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeMetricPoller.class);
    private static final List<Metric> EMPTY = UnmodifiableList.of(new Metric[0]);
    private static final String POLLER_KEY = "PollerName";
    private final Map<String, MetricPoller> pollers;
    private final ExecutorService executor;
    private final long timeout;

    public CompositeMetricPoller(Map<String, MetricPoller> pollers, ExecutorService executor, long timeout) {
        this.pollers = Collections.unmodifiableMap(pollers);
        this.executor = executor;
        this.timeout = timeout;
    }

    private void increment(Throwable t, String name) {
    }

    private List<Metric> getMetrics(String name, Future<List<Metric>> future) {
        List<Metric> metrics = EMPTY;
        try {
            metrics = future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.increment(e, name);
            LOGGER.warn("uncaught exception from poll method for " + name, (Throwable)e);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            this.increment(e, name);
            LOGGER.warn("timeout executing poll method for " + name, (Throwable)e);
        }
        catch (InterruptedException e) {
            this.increment(e, name);
            LOGGER.warn("interrupted while doing get for " + name, (Throwable)e);
        }
        return metrics;
    }

    @Override
    public final List<Metric> poll(MetricFilter filter) {
        return this.poll(filter, false);
    }

    @Override
    public final List<Metric> poll(MetricFilter filter, boolean reset) {
        HashMap<String, Future<List<Metric>>> futures = new HashMap<String, Future<List<Metric>>>();
        for (Map.Entry<String, MetricPoller> e : this.pollers.entrySet()) {
            PollCallable task = new PollCallable(e.getValue(), filter, reset);
            futures.put(e.getKey(), this.executor.submit(task));
        }
        ArrayList<Metric> allMetrics = new ArrayList<Metric>();
        for (Map.Entry e : futures.entrySet()) {
            allMetrics.addAll(this.getMetrics((String)e.getKey(), (Future)e.getValue()));
        }
        return allMetrics;
    }
}

