/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumericMonitor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class AnnotatedNumberMonitor
extends AbstractMonitor<Number>
implements NumericMonitor<Number> {
    private final Object object;
    private final AccessibleObject field;

    AnnotatedNumberMonitor(MonitorConfig config, Object object, AccessibleObject field) {
        super(config);
        this.object = object;
        this.field = field;
    }

    @Override
    public Number getValue() {
        try {
            this.field.setAccessible(true);
            if (this.field instanceof Field) {
                return (Number)((Field)this.field).get(this.object);
            }
            return (Number)((Method)this.field).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AnnotatedNumberMonitor)) {
            return false;
        }
        AnnotatedNumberMonitor m = (AnnotatedNumberMonitor)obj;
        return this.config.equals(m.getConfig()) && this.field.equals(m.field);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.field});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("field", (Object)this.field).toString();
    }
}

