/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.tag.TagList;
import java.util.List;

class CompositeMonitorWrapper<T>
extends AbstractMonitor<T>
implements CompositeMonitor<T> {
    private final TagList tags;
    private final CompositeMonitor<T> monitor;

    public CompositeMonitorWrapper(TagList tags, CompositeMonitor<T> monitor) {
        super(monitor.getConfig().withAdditionalTags(tags));
        this.tags = tags;
        this.monitor = monitor;
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        List<Monitor<?>> monitors = this.monitor.getMonitors();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Monitor<?> m : monitors) {
            builder.add(Monitors.wrap(this.tags, m));
        }
        return builder.build();
    }

    @Override
    public T getValue(int pollerIdx) {
        return this.monitor.getValue(pollerIdx);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CompositeMonitorWrapper)) {
            return false;
        }
        CompositeMonitorWrapper m = (CompositeMonitorWrapper)obj;
        return this.config.equals(m.getConfig()) && this.monitor.equals(m.monitor);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.monitor});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("monitor", this.monitor).toString();
    }
}

