/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.CoderException;
import oracle.security.crypto.fips.FIPS_140_2;

public abstract class Coder {
    protected Coder() {
    }

    public abstract int getBlockSize();

    public byte[] encode(byte[] byArray, int n, int n2) throws CoderException {
        FIPS_140_2.assertReadyState();
        byte[] byArray2 = new byte[n2];
        int n3 = this.getBlockSize();
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (byArray2.length % n3 != 0) {
            throw new CoderException("Data size is not a multiple of block size");
        }
        byte[] byArray5 = new byte[byArray2.length];
        int n4 = byArray2.length;
        for (int i2 = 0; i2 < n4; i2 += n3) {
            System.arraycopy(byArray2, i2, byArray3, 0, n3);
            byArray4 = this.encodeOp(byArray3);
            System.arraycopy(byArray4, 0, byArray5, i2, n3);
        }
        return byArray5;
    }

    public byte[] encode(byte[] byArray) throws CoderException {
        return this.encode(byArray, 0, byArray.length);
    }

    public abstract byte[] encodeOp(byte[] var1) throws CoderException;

    public byte[] decode(byte[] byArray, int n, int n2) throws CoderException {
        FIPS_140_2.assertReadyState();
        byte[] byArray2 = new byte[n2];
        int n3 = this.getBlockSize();
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (byArray2.length % n3 != 0) {
            throw new CoderException("Data size is not a multiple of block size");
        }
        byte[] byArray5 = new byte[byArray2.length];
        int n4 = byArray2.length;
        for (int i2 = 0; i2 < n4; i2 += n3) {
            System.arraycopy(byArray2, i2, byArray3, 0, n3);
            byArray4 = this.decodeOp(byArray3);
            System.arraycopy(byArray4, 0, byArray5, i2, n3);
        }
        return byArray5;
    }

    public byte[] decode(byte[] byArray) throws CoderException {
        return this.decode(byArray, 0, byArray.length);
    }

    public abstract byte[] decodeOp(byte[] var1) throws CoderException;

    public abstract String algName();

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

