/*
 * Decompiled with CFR 0.152.
 */
package com.pgvector;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.postgresql.PGConnection;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;

public class PGvector
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    private float[] vec;

    public PGvector() {
        this.type = "vector";
    }

    public PGvector(float[] v) {
        this();
        this.vec = v;
    }

    public <T extends Number> PGvector(List<T> v) {
        this();
        if (Objects.isNull(v)) {
            this.vec = null;
        } else {
            this.vec = new float[v.size()];
            int i = 0;
            for (Number f : v) {
                this.vec[i++] = f.floatValue();
            }
        }
    }

    public PGvector(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public void setValue(String s) throws SQLException {
        if (s == null) {
            this.vec = null;
        } else {
            String[] sp = s.substring(1, s.length() - 1).split(",");
            this.vec = new float[sp.length];
            for (int i = 0; i < sp.length; ++i) {
                this.vec[i] = Float.parseFloat(sp[i]);
            }
        }
    }

    public String getValue() {
        if (this.vec == null) {
            return null;
        }
        return Arrays.toString(this.vec).replace(" ", "");
    }

    public int lengthInBytes() {
        return this.vec == null ? 0 : 4 + this.vec.length * 4;
    }

    public void setByteValue(byte[] value, int offset) throws SQLException {
        int dim = ByteConverter.int2((byte[])value, (int)offset);
        short unused = ByteConverter.int2((byte[])value, (int)(offset + 2));
        if (unused != 0) {
            throw new SQLException("expected unused to be 0");
        }
        this.vec = new float[dim];
        for (int i = 0; i < dim; ++i) {
            this.vec[i] = ByteConverter.float4((byte[])value, (int)(offset + 4 + i * 4));
        }
    }

    public void toBytes(byte[] bytes, int offset) {
        if (this.vec == null) {
            return;
        }
        ByteConverter.int2((byte[])bytes, (int)offset, (int)this.vec.length);
        ByteConverter.int2((byte[])bytes, (int)(offset + 2), (int)0);
        for (int i = 0; i < this.vec.length; ++i) {
            ByteConverter.float4((byte[])bytes, (int)(offset + 4 + i * 4), (float)this.vec[i]);
        }
    }

    public float[] toArray() {
        return this.vec;
    }

    public static void addVectorType(Connection conn) throws SQLException {
        conn.unwrap(PGConnection.class).addDataType("vector", PGvector.class);
    }
}

