/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public class LineLengthCheck
extends Check {
    public static final String MSG_KEY = "maxLineLen";
    private static final int DEFAULT_MAX_COLUMNS = 80;
    private int max = 80;
    private Pattern ignorePattern;

    public LineLengthCheck() {
        this.setIgnorePattern("^$");
    }

    @Override
    public int[] getDefaultTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getAcceptableTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        String[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int realLength = CommonUtils.lengthExpandedTabs(line, line.length(), this.getTabWidth());
            if (realLength <= this.max || this.ignorePattern.matcher(line).find()) continue;
            this.log(i + 1, MSG_KEY, this.max, realLength);
        }
    }

    public void setMax(int length) {
        this.max = length;
    }

    public final void setIgnorePattern(String format) {
        this.ignorePattern = CommonUtils.createPattern(format);
    }
}

