/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdn.v20180606.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class StopCdnDomainRequest extends AbstractModel{

    /**
    * 域名
域名需要为【已启动】状态
    */
    @SerializedName("Domain")
    @Expose
    private String Domain;

    /**
     * Get 域名
域名需要为【已启动】状态 
     * @return Domain 域名
域名需要为【已启动】状态
     */
    public String getDomain() {
        return this.Domain;
    }

    /**
     * Set 域名
域名需要为【已启动】状态
     * @param Domain 域名
域名需要为【已启动】状态
     */
    public void setDomain(String Domain) {
        this.Domain = Domain;
    }

    public StopCdnDomainRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public StopCdnDomainRequest(StopCdnDomainRequest source) {
        if (source.Domain != null) {
            this.Domain = new String(source.Domain);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Domain", this.Domain);

    }
}

