/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cpdp.v20190820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateCloudSubMerchantResponse extends AbstractModel{

    /**
    * 子应用ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("SubAppId")
    @Expose
    private String SubAppId;

    /**
    * 渠道子商户ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ChannelSubMerchantId")
    @Expose
    private String ChannelSubMerchantId;

    /**
    * 层级，从0开始
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Level")
    @Expose
    private Long Level;

    /**
    * 渠道应用ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ChannelAppId")
    @Expose
    private String ChannelAppId;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 子应用ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return SubAppId 子应用ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getSubAppId() {
        return this.SubAppId;
    }

    /**
     * Set 子应用ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param SubAppId 子应用ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setSubAppId(String SubAppId) {
        this.SubAppId = SubAppId;
    }

    /**
     * Get 渠道子商户ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ChannelSubMerchantId 渠道子商户ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getChannelSubMerchantId() {
        return this.ChannelSubMerchantId;
    }

    /**
     * Set 渠道子商户ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param ChannelSubMerchantId 渠道子商户ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setChannelSubMerchantId(String ChannelSubMerchantId) {
        this.ChannelSubMerchantId = ChannelSubMerchantId;
    }

    /**
     * Get 层级，从0开始
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Level 层级，从0开始
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getLevel() {
        return this.Level;
    }

    /**
     * Set 层级，从0开始
注意：此字段可能返回 null，表示取不到有效值。
     * @param Level 层级，从0开始
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setLevel(Long Level) {
        this.Level = Level;
    }

    /**
     * Get 渠道应用ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ChannelAppId 渠道应用ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getChannelAppId() {
        return this.ChannelAppId;
    }

    /**
     * Set 渠道应用ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param ChannelAppId 渠道应用ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setChannelAppId(String ChannelAppId) {
        this.ChannelAppId = ChannelAppId;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public CreateCloudSubMerchantResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateCloudSubMerchantResponse(CreateCloudSubMerchantResponse source) {
        if (source.SubAppId != null) {
            this.SubAppId = new String(source.SubAppId);
        }
        if (source.ChannelSubMerchantId != null) {
            this.ChannelSubMerchantId = new String(source.ChannelSubMerchantId);
        }
        if (source.Level != null) {
            this.Level = new Long(source.Level);
        }
        if (source.ChannelAppId != null) {
            this.ChannelAppId = new String(source.ChannelAppId);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "SubAppId", this.SubAppId);
        this.setParamSimple(map, prefix + "ChannelSubMerchantId", this.ChannelSubMerchantId);
        this.setParamSimple(map, prefix + "Level", this.Level);
        this.setParamSimple(map, prefix + "ChannelAppId", this.ChannelAppId);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

