/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.essbasic.v20210526.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class UploadFilesResponse extends AbstractModel{

    /**
    * 文件id数组，有效期一个小时；有效期内此文件id可以反复使用
    */
    @SerializedName("FileIds")
    @Expose
    private String [] FileIds;

    /**
    * 上传成功文件数量
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * 文件Url
    */
    @SerializedName("FileUrls")
    @Expose
    private String [] FileUrls;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 文件id数组，有效期一个小时；有效期内此文件id可以反复使用 
     * @return FileIds 文件id数组，有效期一个小时；有效期内此文件id可以反复使用
     */
    public String [] getFileIds() {
        return this.FileIds;
    }

    /**
     * Set 文件id数组，有效期一个小时；有效期内此文件id可以反复使用
     * @param FileIds 文件id数组，有效期一个小时；有效期内此文件id可以反复使用
     */
    public void setFileIds(String [] FileIds) {
        this.FileIds = FileIds;
    }

    /**
     * Get 上传成功文件数量 
     * @return TotalCount 上传成功文件数量
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set 上传成功文件数量
     * @param TotalCount 上传成功文件数量
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get 文件Url 
     * @return FileUrls 文件Url
     */
    public String [] getFileUrls() {
        return this.FileUrls;
    }

    /**
     * Set 文件Url
     * @param FileUrls 文件Url
     */
    public void setFileUrls(String [] FileUrls) {
        this.FileUrls = FileUrls;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public UploadFilesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public UploadFilesResponse(UploadFilesResponse source) {
        if (source.FileIds != null) {
            this.FileIds = new String[source.FileIds.length];
            for (int i = 0; i < source.FileIds.length; i++) {
                this.FileIds[i] = new String(source.FileIds[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.FileUrls != null) {
            this.FileUrls = new String[source.FileUrls.length];
            for (int i = 0; i < source.FileUrls.length; i++) {
                this.FileUrls[i] = new String(source.FileUrls[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "FileIds.", this.FileIds);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArraySimple(map, prefix + "FileUrls.", this.FileUrls);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

