/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.gse.v20191112.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class UpdateGameServerSessionQueueResponse extends AbstractModel{

    /**
    * 部署服务组对象
    */
    @SerializedName("GameServerSessionQueue")
    @Expose
    private GameServerSessionQueue GameServerSessionQueue;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 部署服务组对象 
     * @return GameServerSessionQueue 部署服务组对象
     */
    public GameServerSessionQueue getGameServerSessionQueue() {
        return this.GameServerSessionQueue;
    }

    /**
     * Set 部署服务组对象
     * @param GameServerSessionQueue 部署服务组对象
     */
    public void setGameServerSessionQueue(GameServerSessionQueue GameServerSessionQueue) {
        this.GameServerSessionQueue = GameServerSessionQueue;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public UpdateGameServerSessionQueueResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public UpdateGameServerSessionQueueResponse(UpdateGameServerSessionQueueResponse source) {
        if (source.GameServerSessionQueue != null) {
            this.GameServerSessionQueue = new GameServerSessionQueue(source.GameServerSessionQueue);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "GameServerSessionQueue.", this.GameServerSessionQueue);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

