/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.monitor.v20180724.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class PrometheusAlertManagerConfig extends AbstractModel{

    /**
    * alertmanager url
    */
    @SerializedName("Url")
    @Expose
    private String Url;

    /**
    * alertmanager部署所在集群类型
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ClusterType")
    @Expose
    private String ClusterType;

    /**
    * alertmanager部署所在集群ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ClusterId")
    @Expose
    private String ClusterId;

    /**
     * Get alertmanager url 
     * @return Url alertmanager url
     */
    public String getUrl() {
        return this.Url;
    }

    /**
     * Set alertmanager url
     * @param Url alertmanager url
     */
    public void setUrl(String Url) {
        this.Url = Url;
    }

    /**
     * Get alertmanager部署所在集群类型
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ClusterType alertmanager部署所在集群类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getClusterType() {
        return this.ClusterType;
    }

    /**
     * Set alertmanager部署所在集群类型
注意：此字段可能返回 null，表示取不到有效值。
     * @param ClusterType alertmanager部署所在集群类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setClusterType(String ClusterType) {
        this.ClusterType = ClusterType;
    }

    /**
     * Get alertmanager部署所在集群ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ClusterId alertmanager部署所在集群ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getClusterId() {
        return this.ClusterId;
    }

    /**
     * Set alertmanager部署所在集群ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param ClusterId alertmanager部署所在集群ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setClusterId(String ClusterId) {
        this.ClusterId = ClusterId;
    }

    public PrometheusAlertManagerConfig() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public PrometheusAlertManagerConfig(PrometheusAlertManagerConfig source) {
        if (source.Url != null) {
            this.Url = new String(source.Url);
        }
        if (source.ClusterType != null) {
            this.ClusterType = new String(source.ClusterType);
        }
        if (source.ClusterId != null) {
            this.ClusterId = new String(source.ClusterId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Url", this.Url);
        this.setParamSimple(map, prefix + "ClusterType", this.ClusterType);
        this.setParamSimple(map, prefix + "ClusterId", this.ClusterId);

    }
}

