/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryName;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.file.FileInputSocket;
import de.schlichtherle.truezip.fs.file.FileOutputSocket;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
class FileEntry
extends FsEntry
implements IOEntry<FileEntry> {
    private static final BitField<FsOutputOption> NO_OUTPUT_OPTIONS = BitField.noneOf(FsOutputOption.class);
    private final File file;
    private final EntryName name;

    FileEntry(File file) {
        assert (null != file);
        this.file = file;
        this.name = EntryName.create((String)file.getName());
    }

    FileEntry(File file, FsEntryName name) {
        assert (null != file);
        this.file = new File(file, name.getPath());
        this.name = name;
    }

    final File getFile() {
        return this.file;
    }

    public final String getName() {
        return this.name.toString();
    }

    public final Entry.Type getType() {
        return this.file.isDirectory() ? Entry.Type.DIRECTORY : (this.file.isFile() ? Entry.Type.FILE : (this.file.exists() ? Entry.Type.SPECIAL : null));
    }

    public final long getSize(Entry.Size type) {
        switch (type) {
            case DATA: 
            case STORAGE: {
                return this.file.exists() ? this.file.length() : -1L;
            }
        }
        return -1L;
    }

    public final long getTime(Entry.Access type) {
        return Entry.Access.WRITE == type && this.file.exists() ? this.file.lastModified() : -1L;
    }

    @Nullable
    public final Set<String> getMembers() {
        String[] list = this.file.list();
        return null == list ? null : Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(list)));
    }

    public final InputSocket<FileEntry> getInputSocket() {
        return new FileInputSocket(this);
    }

    public final OutputSocket<FileEntry> getOutputSocket() {
        return new FileOutputSocket(this, NO_OUTPUT_OPTIONS, null);
    }

    public final OutputSocket<FileEntry> getOutputSocket(BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new FileOutputSocket(this, options, template);
    }
}

