/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.fs.file.FileEntry;
import de.schlichtherle.truezip.socket.IOPool;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.io.IOException;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class TempFilePool
implements IOPool<FileEntry> {
    public static final TempFilePool INSTANCE = new TempFilePool("tzp", null, null);
    private final String prefix;
    @Nullable
    private final String suffix;
    @Nullable
    private final File dir;

    public TempFilePool(String prefix, @Nullable String suffix, @Nullable File dir) {
        if (null == prefix) {
            throw new NullPointerException();
        }
        this.prefix = prefix;
        this.suffix = suffix;
        this.dir = dir;
    }

    public Entry allocate() throws IOException {
        return new Entry(File.createTempFile(this.prefix, this.suffix, this.dir), this);
    }

    public void release(IOPool.Entry<FileEntry> resource) throws IOException {
        resource.release();
    }

    @NotThreadSafe
    @DefaultAnnotation(value={NonNull.class})
    public static final class Entry
    extends FileEntry
    implements IOPool.Entry<FileEntry> {
        @CheckForNull
        private TempFilePool pool;

        private Entry(File file, TempFilePool pool) {
            super(file);
            assert (null != pool);
            assert (null != file);
            this.pool = pool;
        }

        public void release() throws IOException {
            if (null == this.pool) {
                throw new IllegalStateException(this.getFile() + " (already released)");
            }
            this.pool(null);
        }

        private TempFilePool pool(@CheckForNull TempFilePool newPool) throws IOException {
            File file;
            TempFilePool oldPool = this.pool;
            this.pool = newPool;
            if (oldPool != newPool && !(file = this.getFile()).delete() && file.exists()) {
                throw new IOException(file + " (cannot delete temporary file)");
            }
            return oldPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pool(null);
            }
            finally {
                super.finalize();
            }
        }
    }
}

