/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.entry;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public class EntryName
implements Serializable,
Comparable<EntryName> {
    private static final long serialVersionUID = 2927354934726235478L;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    @NonNull
    private URI uri;

    @NonNull
    public static EntryName create(@NonNull String uri) {
        try {
            return new EntryName(uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NonNull
    public static EntryName create(@NonNull String path, @CheckForNull String query) {
        try {
            return new EntryName(new URI(null, null, path, query, null));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @NonNull
    public static EntryName create(@NonNull URI uri) {
        try {
            return new EntryName(uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public EntryName(@NonNull String uri) throws URISyntaxException {
        this.parse(new URI(uri));
    }

    public EntryName(@NonNull URI uri) throws URISyntaxException {
        this.parse(uri);
    }

    public EntryName(@NonNull EntryName parent, @NonNull EntryName member) {
        URI parentUri = parent.uri;
        String parentUriPath = parentUri.getPath();
        URI memberUri = member.uri;
        try {
            this.uri = 0 == parentUriPath.length() ? memberUri : (parentUriPath.endsWith(SEPARATOR) ? parentUri.resolve(memberUri) : (0 == memberUri.getPath().length() ? new URI(null, null, parentUriPath, memberUri.getQuery(), null) : new URI(null, null, parentUriPath + '/', null, null).resolve(memberUri)));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        assert (this.invariants());
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()));
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(@NonNull URI uri) throws URISyntaxException {
        if (uri.isAbsolute()) {
            throw new URISyntaxException(EntryName.quote(uri), "Scheme not allowed");
        }
        if (uri.getRawAuthority() != null) {
            throw new URISyntaxException(EntryName.quote(uri), "Authority not allowed");
        }
        if (null != uri.getRawFragment()) {
            throw new URISyntaxException(EntryName.quote(uri), "Fragment not allowed");
        }
        this.uri = uri;
        assert (this.invariants());
    }

    private static String quote(Object s) {
        return "\"" + s + "\"";
    }

    private boolean invariants() {
        assert (null != this.getUri());
        assert (!this.getUri().isAbsolute());
        assert (null == this.getUri().getRawAuthority());
        assert (null == this.getUri().getRawFragment());
        return true;
    }

    @NonNull
    public final String getPath() {
        return this.uri.getPath();
    }

    @CheckForNull
    public final String getQuery() {
        return this.uri.getQuery();
    }

    @NonNull
    public final URI getUri() {
        return this.uri;
    }

    public final boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof EntryName && this.uri.equals(((EntryName)that).uri);
    }

    @Override
    public final int compareTo(@NonNull EntryName that) {
        return this.uri.compareTo(that.uri);
    }

    public final int hashCode() {
        return this.uri.hashCode();
    }

    @NonNull
    public final String toString() {
        return this.uri.toString();
    }
}

