/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsDecoratingEntry;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOCache;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class FsCachingController
extends FsDecoratingController<FsConcurrentModel, FsController<? extends FsConcurrentModel>> {
    private static final IOCache.Strategy STRATEGY = IOCache.Strategy.WRITE_BACK;
    private final IOPool<?> pool;
    private final Map<FsEntryName, Cache> caches = new HashMap<FsEntryName, Cache>();

    public FsCachingController(@NonNull FsController<? extends FsConcurrentModel> controller, @NonNull IOPool<?> pool) {
        super(controller);
        if (null == pool) {
            throw new NullPointerException();
        }
        this.pool = pool;
    }

    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        FsEntry entry;
        Cache cache = this.caches.get(name);
        return null != cache && null != (entry = cache.getEntry()) ? entry : this.delegate.getEntry(name);
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new Input(name, options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return new Output(name, options, template);
    }

    @Override
    public void mknod(@NonNull FsEntryName name, @NonNull Entry.Type type, @NonNull BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        assert (((FsConcurrentModel)this.getModel()).writeLock().isHeldByCurrentThread());
        Cache cache = this.caches.get(name);
        if (null != cache) {
            this.delegate.mknod(name, type, options, template);
            this.caches.remove(name);
            cache.clear();
        } else {
            this.delegate.mknod(name, type, options, template);
        }
    }

    @Override
    public void unlink(@NonNull FsEntryName name) throws IOException {
        assert (((FsConcurrentModel)this.getModel()).writeLock().isHeldByCurrentThread());
        Cache cache = this.caches.get(name);
        if (null != cache) {
            this.delegate.unlink(name);
            this.caches.remove(name);
            cache.clear();
        } else {
            this.delegate.unlink(name);
        }
    }

    @Override
    public <X extends IOException> void sync(@NonNull BitField<FsSyncOption> options, @NonNull ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.beforeSync(options, handler);
        this.delegate.sync(options.clear(FsSyncOption.CLEAR_CACHE), handler);
    }

    private <X extends IOException> void beforeSync(@NonNull BitField<FsSyncOption> options, @NonNull ExceptionHandler<? super FsSyncException, X> handler) throws X {
        assert (((FsConcurrentModel)this.getModel()).writeLock().isHeldByCurrentThread());
        if (0 >= this.caches.size()) {
            return;
        }
        boolean flush = !options.get(FsSyncOption.ABORT_CHANGES);
        boolean clear = !flush || options.get(FsSyncOption.CLEAR_CACHE);
        Iterator<Cache> i = this.caches.values().iterator();
        while (i.hasNext()) {
            Cache cache = i.next();
            try {
                if (!flush) continue;
                cache.flush();
            }
            catch (IOException ex) {
                throw (IOException)handler.fail(new FsSyncException((FsModel)this.getModel(), ex));
            }
            finally {
                try {
                    if (!clear) continue;
                    i.remove();
                    cache.clear();
                }
                catch (IOException ex) {
                    handler.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
                }
            }
        }
    }

    private static class ProxyFileSystemEntry
    extends FsDecoratingEntry<Entry> {
        ProxyFileSystemEntry(Entry entry) {
            super(entry);
            assert (Entry.Type.DIRECTORY != entry.getType());
        }

        @Override
        public Set<String> getMembers() {
            return null;
        }
    }

    private final class Cache {
        private final FsEntryName name;
        private final IOCache cache;
        private volatile InputSocket<?> input;
        private volatile OutputSocket<?> output;
        private volatile BitField<FsOutputOption> outputOptions;
        private volatile Entry template;

        Cache(FsEntryName name) {
            this.name = name;
            this.cache = STRATEGY.newCache(FsCachingController.this.pool);
        }

        @NonNull
        public Cache configure(@NonNull BitField<FsInputOption> options) {
            this.cache.configure(FsCachingController.this.delegate.getInputSocket(this.name, options.clear(FsInputOption.CACHE)));
            this.input = null;
            return this;
        }

        @NonNull
        public Cache configure(@NonNull BitField<FsOutputOption> options, @Nullable Entry template) {
            this.outputOptions = options.clear(FsOutputOption.CACHE);
            this.template = template;
            this.cache.configure(FsCachingController.this.delegate.getOutputSocket(this.name, this.outputOptions, this.template));
            this.output = null;
            return this;
        }

        public void flush() throws IOException {
            this.cache.flush();
        }

        public void clear() throws IOException {
            this.cache.clear();
        }

        @CheckForNull
        public FsEntry getEntry() {
            Entry entry = this.cache.getEntry();
            return null == entry ? null : new ProxyFileSystemEntry(null == this.template ? entry : this.template);
        }

        public InputSocket<?> getInputSocket() {
            return null != this.input ? this.input : (this.input = this.cache.getInputSocket());
        }

        public OutputSocket<?> getOutputSocket() {
            return null != this.output ? this.output : (this.output = new ProxyOutputSocket(this.cache.getOutputSocket()));
        }

        private final class ProxyOutputSocket
        extends DecoratingOutputSocket<Entry> {
            private ProxyOutputSocket(OutputSocket<?> output) {
                super(output);
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                assert (((FsConcurrentModel)FsCachingController.this.getModel()).writeLock().isHeldByCurrentThread());
                this.makeEntry();
                OutputStream out = this.getBoundSocket().newOutputStream();
                FsCachingController.this.caches.put(Cache.this.name, Cache.this);
                return out;
            }

            private void makeEntry() throws IOException {
                boolean mknod;
                boolean bl = mknod = null != Cache.this.template;
                if (!mknod) {
                    try {
                        FsEntry entry = FsCachingController.this.delegate.getEntry(Cache.this.name);
                        mknod = null == entry || entry.getType() != Entry.Type.FILE;
                    }
                    catch (FsFalsePositiveException ex) {
                        mknod = true;
                    }
                }
                if (mknod) {
                    FsCachingController.this.delegate.mknod(Cache.this.name, Entry.Type.FILE, Cache.this.outputOptions, Cache.this.template);
                } else {
                    ((FsConcurrentModel)FsCachingController.this.getModel()).setTouched(true);
                }
                assert (((FsConcurrentModel)FsCachingController.this.getModel()).isTouched());
            }
        }
    }

    private class Output
    extends DecoratingOutputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsOutputOption> options;
        final Entry template;

        Output(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
            super(FsCachingController.this.delegate.getOutputSocket(name, options, template));
            this.name = name;
            this.options = options;
            this.template = template;
        }

        @Override
        public OutputSocket<?> getBoundSocket() throws IOException {
            Cache cache = (Cache)FsCachingController.this.caches.get(this.name);
            if (null == cache) {
                if (!this.options.get(FsOutputOption.CACHE)) {
                    return super.getBoundSocket();
                }
                cache = new Cache(this.name);
            } else if (this.options.get(FsOutputOption.APPEND)) {
                assert (IOCache.Strategy.WRITE_THROUGH == STRATEGY);
                cache.flush();
            }
            return cache.configure(this.options, this.template).getOutputSocket().bind(this);
        }
    }

    private class Input
    extends DecoratingInputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsInputOption> options;

        Input(FsEntryName name, BitField<FsInputOption> options) {
            super(FsCachingController.this.delegate.getInputSocket(name, options));
            this.name = name;
            this.options = options;
        }

        @Override
        public InputSocket<?> getBoundSocket() throws IOException {
            Cache cache = (Cache)FsCachingController.this.caches.get(this.name);
            if (null == cache) {
                if (!this.options.get(FsInputOption.CACHE)) {
                    return super.getBoundSocket();
                }
                cache = new Cache(this.name);
            }
            return cache.configure(this.options).getInputSocket().bind(this);
        }
    }
}

