/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverService;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsScheme;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.ServiceConfigurationError;
import net.jcip.annotations.Immutable;

@Immutable
public final class FsDefaultDriver
implements FsCompositeDriver {
    private final Map<FsScheme, ? extends FsDriver> drivers;

    public FsDefaultDriver(@NonNull FsDriverService service) {
        this.drivers = service.getDrivers();
        assert (null != this.drivers);
    }

    @Override
    public FsController<?> newController(FsMountPoint mountPoint, FsController<?> parent) {
        assert (null != mountPoint.getParent() ? mountPoint.getParent().equals(((FsModel)parent.getModel()).getMountPoint()) : null == parent);
        FsScheme scheme = mountPoint.getScheme();
        FsDriver driver = this.drivers.get(scheme);
        if (null == driver) {
            throw new ServiceConfigurationError(scheme + "(unknown file system scheme)");
        }
        return driver.newController(mountPoint, parent);
    }
}

