/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.AbstractReadOnlyFile;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class ByteArrayReadOnlyFile
extends AbstractReadOnlyFile {
    private final byte[] data;
    private int offset;
    private int length;

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public ByteArrayReadOnlyFile(byte[] data) {
        if (null == data) {
            throw new NullPointerException();
        }
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public ByteArrayReadOnlyFile(byte[] data, int offset, int length) {
        if (null == data) {
            throw new NullPointerException();
        }
        this.data = data;
        this.offset = offset;
        this.length = Math.min(offset + length, data.length);
    }

    @Override
    public synchronized long length() {
        return this.length;
    }

    @Override
    public synchronized long getFilePointer() {
        return this.offset;
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        if (0L > pos) {
            throw new IOException();
        }
        this.offset = pos < (long)this.length ? (int)pos : this.length;
    }

    @Override
    public synchronized int read() {
        return this.offset < this.length ? this.data[this.offset++] & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (0 > (off | len | b.length - off - len)) {
            throw new IndexOutOfBoundsException();
        }
        if (0 >= len) {
            return 0;
        }
        if (this.offset + len > this.length) {
            len = this.length - this.offset;
        }
        if (this.offset >= this.length) {
            return -1;
        }
        System.arraycopy(this.data, this.offset, b, off, len);
        this.offset += len;
        return len;
    }

    @Override
    public void close() {
    }
}

