/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.zhipu.AuthorizationInterceptor;
import dev.langchain4j.model.zhipu.DefaultZhipuAiHelper;
import dev.langchain4j.model.zhipu.Json;
import dev.langchain4j.model.zhipu.RequestLoggingInterceptor;
import dev.langchain4j.model.zhipu.ResponseLoggingInterceptor;
import dev.langchain4j.model.zhipu.ZhipuAiApi;
import dev.langchain4j.model.zhipu.ZhipuAiException;
import dev.langchain4j.model.zhipu.chat.ChatCompletionChoice;
import dev.langchain4j.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.model.zhipu.chat.ChatCompletionResponse;
import dev.langchain4j.model.zhipu.chat.ToolCall;
import dev.langchain4j.model.zhipu.embedding.EmbeddingRequest;
import dev.langchain4j.model.zhipu.embedding.EmbeddingResponse;
import dev.langchain4j.model.zhipu.image.ImageRequest;
import dev.langchain4j.model.zhipu.image.ImageResponse;
import dev.langchain4j.model.zhipu.shared.Usage;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class ZhipuAiClient {
    private static final Logger log = LoggerFactory.getLogger(ZhipuAiClient.class);
    private final ZhipuAiApi zhipuAiApi;
    private final OkHttpClient okHttpClient;
    private final Boolean logResponses;

    public ZhipuAiClient(Builder builder) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(builder.callTimeout).connectTimeout(builder.connectTimeout).readTimeout(builder.readTimeout).writeTimeout(builder.writeTimeout).addInterceptor((Interceptor)new AuthorizationInterceptor(builder.apiKey));
        if (builder.logRequests) {
            okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor());
        }
        this.logResponses = builder.logResponses;
        if (builder.logResponses) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor());
        }
        this.okHttpClient = okHttpClientBuilder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)builder.baseUrl)).client(this.okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)Json.OBJECT_MAPPER)).build();
        this.zhipuAiApi = (ZhipuAiApi)retrofit.create(ZhipuAiApi.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ChatCompletionResponse chatCompletion(ChatCompletionRequest request) {
        retrofit2.Response retrofitResponse;
        try {
            retrofitResponse = this.zhipuAiApi.chatCompletion(request).execute();
        }
        catch (IOException e) {
            return DefaultZhipuAiHelper.toChatErrorResponse(e);
        }
        if (retrofitResponse.isSuccessful()) {
            return (ChatCompletionResponse)retrofitResponse.body();
        }
        return DefaultZhipuAiHelper.toChatErrorResponse(retrofitResponse);
    }

    public EmbeddingResponse embedAll(EmbeddingRequest request) {
        try {
            retrofit2.Response responseResponse = this.zhipuAiApi.embeddings(request).execute();
            if (responseResponse.isSuccessful()) {
                return (EmbeddingResponse)responseResponse.body();
            }
            throw this.toException(responseResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void streamingChatCompletion(final ChatCompletionRequest request, final StreamingResponseHandler<AiMessage> handler, final List<ChatModelListener> listeners, final ChatModelRequestContext requestContext) {
        EventSourceListener eventSourceListener = new EventSourceListener(){
            final StringBuffer contentBuilder = new StringBuffer();
            List<ToolExecutionRequest> specifications;
            TokenUsage tokenUsage;
            FinishReason finishReason;
            ChatCompletionResponse chatCompletionResponse;

            public void onOpen(@NotNull EventSource eventSource, @NotNull okhttp3.Response response) {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onOpen()");
                }
            }

            public void onEvent(@NotNull EventSource eventSource, String id, String type, @NotNull String data) {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onEvent() {}", (Object)data);
                }
                if ("[DONE]".equals(data)) {
                    AiMessage aiMessage = Utils.isNullOrEmpty(this.specifications) ? AiMessage.from((String)this.contentBuilder.toString()) : AiMessage.from(this.specifications);
                    Response response = Response.from((Object)aiMessage, (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
                    ChatModelResponse modelListenerResponse = DefaultZhipuAiHelper.createModelListenerResponse(this.chatCompletionResponse.getId(), request.getModel(), (Response<AiMessage>)response);
                    ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, requestContext.request(), requestContext.attributes());
                    for (ChatModelListener listener : listeners) {
                        try {
                            listener.onResponse(responseContext);
                        }
                        catch (Exception e) {
                            log.warn("Exception while calling model listener", (Throwable)e);
                        }
                    }
                    handler.onComplete(response);
                } else {
                    try {
                        List<ToolCall> toolCalls;
                        String finishReasonString;
                        this.chatCompletionResponse = (ChatCompletionResponse)Json.OBJECT_MAPPER.readValue(data, ChatCompletionResponse.class);
                        ChatCompletionChoice zhipuChatCompletionChoice = this.chatCompletionResponse.getChoices().get(0);
                        String chunk = zhipuChatCompletionChoice.getDelta().getContent();
                        this.contentBuilder.append(chunk);
                        handler.onNext(chunk);
                        Usage zhipuUsageInfo = this.chatCompletionResponse.getUsage();
                        if (zhipuUsageInfo != null) {
                            this.tokenUsage = DefaultZhipuAiHelper.tokenUsageFrom(zhipuUsageInfo);
                        }
                        if ((finishReasonString = zhipuChatCompletionChoice.getFinishReason()) != null) {
                            this.finishReason = DefaultZhipuAiHelper.finishReasonFrom(finishReasonString);
                        }
                        if (!Utils.isNullOrEmpty(toolCalls = zhipuChatCompletionChoice.getDelta().getToolCalls())) {
                            this.specifications = DefaultZhipuAiHelper.specificationsFrom(toolCalls);
                        }
                    }
                    catch (Exception exception) {
                        ZhipuAiClient.this.handleResponseException(exception, (StreamingResponseHandler<AiMessage>)handler, requestContext, listeners);
                    }
                }
            }

            public void onFailure(@NotNull EventSource eventSource, Throwable t, okhttp3.Response response) {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onFailure()", t);
                }
                Throwable throwable = (Throwable)Utils.getOrDefault((Object)t, (Object)new ZhipuAiException(response));
                ZhipuAiClient.this.handleResponseException(throwable, (StreamingResponseHandler<AiMessage>)handler, requestContext, listeners);
            }

            public void onClosed(@NotNull EventSource eventSource) {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onClosed()");
                }
            }
        };
        EventSources.createFactory((OkHttpClient)this.okHttpClient).newEventSource(this.zhipuAiApi.streamingChatCompletion(request).request(), eventSourceListener);
    }

    private void handleResponseException(Throwable throwable, StreamingResponseHandler<AiMessage> handler, ChatModelRequestContext requestContext, List<ChatModelListener> listeners) {
        ChatModelErrorContext errorContext = new ChatModelErrorContext(throwable, requestContext.request(), null, requestContext.attributes());
        listeners.forEach(listener -> {
            try {
                listener.onError(errorContext);
            }
            catch (Exception e2) {
                log.warn("Exception while calling model listener", (Throwable)e2);
            }
        });
        if (throwable instanceof ZhipuAiException) {
            ChatCompletionResponse errorResponse = DefaultZhipuAiHelper.toChatErrorResponse(throwable);
            Response messageResponse = Response.from((Object)DefaultZhipuAiHelper.aiMessageFrom(errorResponse), (TokenUsage)DefaultZhipuAiHelper.tokenUsageFrom(errorResponse.getUsage()), (FinishReason)DefaultZhipuAiHelper.finishReasonFrom(DefaultZhipuAiHelper.getFinishReason(throwable)));
            handler.onComplete(messageResponse);
        } else {
            handler.onError(throwable);
        }
    }

    private RuntimeException toException(retrofit2.Response<?> retrofitResponse) throws IOException {
        int code = retrofitResponse.code();
        if (code >= 400) {
            try (ResponseBody errorBody = retrofitResponse.errorBody();){
                if (errorBody != null) {
                    String errorBodyString = errorBody.string();
                    String errorMessage = String.format("status code: %s; body: %s", code, errorBodyString);
                    log.error("Error response: {}", (Object)errorMessage);
                    RuntimeException runtimeException = new RuntimeException(errorMessage);
                    return runtimeException;
                }
            }
        }
        return new RuntimeException(retrofitResponse.message());
    }

    public ImageResponse imagesGeneration(ImageRequest request) {
        try {
            retrofit2.Response responseResponse = this.zhipuAiApi.generations(request).execute();
            if (responseResponse.isSuccessful()) {
                return (ImageResponse)responseResponse.body();
            }
            throw this.toException(responseResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private String baseUrl = "https://open.bigmodel.cn/";
        private String apiKey;
        private Duration callTimeout = Duration.ofSeconds(60L);
        private Duration connectTimeout = Duration.ofSeconds(60L);
        private Duration readTimeout = Duration.ofSeconds(60L);
        private Duration writeTimeout = Duration.ofSeconds(60L);
        private boolean logRequests;
        private boolean logResponses;

        private Builder() {
        }

        public Builder baseUrl(String baseUrl) {
            if (baseUrl != null && !baseUrl.trim().isEmpty()) {
                this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
                return this;
            }
            throw new IllegalArgumentException("baseUrl cannot be null or empty");
        }

        public Builder apiKey(String apiKey) {
            if (apiKey != null && !apiKey.trim().isEmpty()) {
                this.apiKey = apiKey;
                return this;
            }
            throw new IllegalArgumentException("apiKey cannot be null or empty. ");
        }

        public Builder callTimeout(Duration callTimeout) {
            if (callTimeout == null) {
                throw new IllegalArgumentException("callTimeout cannot be null");
            }
            this.callTimeout = callTimeout;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            if (connectTimeout == null) {
                throw new IllegalArgumentException("connectTimeout cannot be null");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            if (readTimeout == null) {
                throw new IllegalArgumentException("readTimeout cannot be null");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder writeTimeout(Duration writeTimeout) {
            if (writeTimeout == null) {
                throw new IllegalArgumentException("writeTimeout cannot be null");
            }
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder logRequests() {
            return this.logRequests(true);
        }

        public Builder logRequests(Boolean logRequests) {
            if (logRequests == null) {
                logRequests = false;
            }
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses() {
            return this.logResponses(true);
        }

        public Builder logResponses(Boolean logResponses) {
            if (logResponses == null) {
                logResponses = false;
            }
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiClient build() {
            return new ZhipuAiClient(this);
        }
    }
}

