/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.hybrid;

import edu.stanford.nlp.coref.CorefAlgorithm;
import edu.stanford.nlp.coref.CorefPrinter;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.CorefScorer;
import edu.stanford.nlp.coref.CorefUtils;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.CorefCluster;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.DocumentMaker;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.hybrid.HybridCorefPrinter;
import edu.stanford.nlp.coref.hybrid.HybridCorefProperties;
import edu.stanford.nlp.coref.hybrid.sieve.Sieve;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class HybridCorefSystem
implements CorefAlgorithm {
    private static Redwood.RedwoodChannels log = Redwood.channels(HybridCorefSystem.class);
    public Properties props;
    public List<Sieve> sieves;
    public Dictionaries dictionaries;
    public DocumentMaker docMaker = null;

    public HybridCorefSystem(Properties props, Dictionaries dictionaries) throws Exception {
        this.props = props;
        this.dictionaries = dictionaries;
        this.sieves = Sieve.loadSieves(props);
        for (Sieve sieve : this.sieves) {
            if (sieve.classifierType == Sieve.ClassifierType.RULE || !HybridCorefProperties.useWordEmbedding(props, sieve.sievename)) continue;
            props.setProperty("coref.loadWordEmbedding", "true");
        }
    }

    public HybridCorefSystem(Properties props) throws Exception {
        this.props = props;
        this.sieves = Sieve.loadSieves(props);
        for (Sieve sieve : this.sieves) {
            if (sieve.classifierType == Sieve.ClassifierType.RULE || !HybridCorefProperties.useWordEmbedding(props, sieve.sievename)) continue;
            props.setProperty("coref.loadWordEmbedding", "true");
        }
        this.dictionaries = new Dictionaries(props);
        this.docMaker = new DocumentMaker(props, this.dictionaries);
    }

    public Dictionaries dictionaries() {
        return this.dictionaries;
    }

    public static void runCoref(String[] args) throws Exception {
        HybridCorefSystem.runCoref(StringUtils.argsToProperties(args));
    }

    public static void runCoref(Properties props) throws Exception {
        Document document;
        Redwood.hideChannelsEverywhere("debug-cluster", "debug-mention", "debug-preprocessor", "debug-docreader", "debug-mergethres", "debug-featureselection", "debug-md");
        int nThreads = HybridCorefProperties.getThreadCounts(props);
        String timeStamp = Calendar.getInstance().getTime().toString().replaceAll("\\s", "-").replaceAll(":", "-");
        Logger logger = Logger.getLogger(HybridCorefSystem.class.getName());
        if (props.containsKey("coref.logFile")) {
            File logFile = new File(props.getProperty("coref.logFile"));
            RedwoodConfiguration.current().handlers(RedwoodConfiguration.Handlers.file(logFile)).apply();
            Redwood.log("Starting coref log");
        }
        log.info(props.toString());
        if (HybridCorefProperties.checkMemory(props)) {
            HybridCorefSystem.checkMemoryUsage();
        }
        HybridCorefSystem cs = new HybridCorefSystem(props);
        String goldOutput = null;
        String beforeCorefOutput = null;
        String afterCorefOutput = null;
        PrintWriter writerGold = null;
        PrintWriter writerBeforeCoref = null;
        PrintWriter writerAfterCoref = null;
        if (HybridCorefProperties.doScore(props)) {
            String pathOutput = CorefProperties.conllOutputPath(props);
            new File(pathOutput).mkdir();
            goldOutput = pathOutput + "output-" + timeStamp + ".gold.txt";
            beforeCorefOutput = pathOutput + "output-" + timeStamp + ".predicted.txt";
            afterCorefOutput = pathOutput + "output-" + timeStamp + ".coref.predicted.txt";
            writerGold = new PrintWriter(new FileOutputStream(goldOutput));
            writerBeforeCoref = new PrintWriter(new FileOutputStream(beforeCorefOutput));
            writerAfterCoref = new PrintWriter(new FileOutputStream(afterCorefOutput));
        }
        MulticoreWrapper<Pair<Document, HybridCorefSystem>, StringBuilder[]> wrapper = new MulticoreWrapper<Pair<Document, HybridCorefSystem>, StringBuilder[]>(nThreads, new ThreadsafeProcessor<Pair<Document, HybridCorefSystem>, StringBuilder[]>(){

            @Override
            public StringBuilder[] process(Pair<Document, HybridCorefSystem> input) {
                try {
                    Document document = (Document)input.first;
                    HybridCorefSystem cs = (HybridCorefSystem)input.second;
                    StringBuilder[] outputs = new StringBuilder[4];
                    cs.coref(document, outputs);
                    return outputs;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public ThreadsafeProcessor<Pair<Document, HybridCorefSystem>, StringBuilder[]> newInstance() {
                return this;
            }
        });
        Date startTime = null;
        if (HybridCorefProperties.checkTime(props)) {
            startTime = new Date();
            System.err.printf("END-TO-END COREF Start time: %s\n", startTime);
        }
        int docCnt = 0;
        while ((document = cs.docMaker.nextDoc()) != null) {
            wrapper.put(Pair.makePair(document, cs));
            docCnt = HybridCorefSystem.logOutput(wrapper, writerGold, writerBeforeCoref, writerAfterCoref, docCnt);
        }
        wrapper.join();
        docCnt = HybridCorefSystem.logOutput(wrapper, writerGold, writerBeforeCoref, writerAfterCoref, docCnt);
        IOUtils.closeIgnoringExceptions(writerGold);
        IOUtils.closeIgnoringExceptions(writerBeforeCoref);
        IOUtils.closeIgnoringExceptions(writerAfterCoref);
        if (HybridCorefProperties.checkTime(props)) {
            System.err.printf("END-TO-END COREF Elapsed time: %.3f seconds\n", Float.valueOf((float)(new Date().getTime() - startTime.getTime()) / 1000.0f));
        }
        if (HybridCorefProperties.checkMemory(props)) {
            HybridCorefSystem.checkMemoryUsage();
        }
        if (HybridCorefProperties.doScore(props)) {
            String summary = CorefScorer.getEvalSummary(CorefProperties.getScorerPath(props), goldOutput, beforeCorefOutput);
            CorefScorer.printScoreSummary(summary, logger, false);
            summary = CorefScorer.getEvalSummary(CorefProperties.getScorerPath(props), goldOutput, afterCorefOutput);
            CorefScorer.printScoreSummary(summary, logger, true);
            CorefScorer.printFinalConllScore(summary, logger);
        }
    }

    private static int logOutput(MulticoreWrapper<Pair<Document, HybridCorefSystem>, StringBuilder[]> wrapper, PrintWriter writerGold, PrintWriter writerBeforeCoref, PrintWriter writerAfterCoref, int docCnt) {
        while (wrapper.peek()) {
            StringBuilder[] output = wrapper.poll();
            writerGold.print(output[0]);
            writerBeforeCoref.print(output[1]);
            writerAfterCoref.print(output[2]);
            if (output[3].length() > 0) {
                log.info(output[3]);
            }
            if (++docCnt % 10 != 0) continue;
            log.info(docCnt + " document(s) processed");
        }
        return docCnt;
    }

    @Override
    public void runCoref(Document document) {
        try {
            this.coref(document);
        }
        catch (Exception e) {
            throw new RuntimeException("Error running hybrid coref system", e);
        }
    }

    public Map<Integer, CorefChain> coref(Document document, StringBuilder[] output) throws Exception {
        if (HybridCorefProperties.printMDLog(this.props)) {
            Redwood.log(HybridCorefPrinter.printMentionDetectionLog(document));
        }
        if (HybridCorefProperties.doScore(this.props)) {
            output[0] = new StringBuilder().append(CorefPrinter.printConllOutput(document, true));
            output[1] = new StringBuilder().append(CorefPrinter.printConllOutput(document, false));
        }
        output[3] = new StringBuilder();
        for (Sieve sieve : this.sieves) {
            CorefUtils.checkForInterrupt();
            output[3].append(sieve.resolveMention(document, this.dictionaries, this.props));
        }
        if (HybridCorefProperties.doPostProcessing(this.props)) {
            HybridCorefSystem.postProcessing(document);
        }
        if (HybridCorefProperties.doScore(this.props)) {
            output[2] = new StringBuilder().append(CorefPrinter.printConllOutput(document, false, true));
        }
        return HybridCorefSystem.makeCorefOutput(document);
    }

    public Map<Integer, CorefChain> coref(Document document) throws Exception {
        return this.coref(document, new StringBuilder[4]);
    }

    public Map<Integer, CorefChain> coref(Annotation anno) throws Exception {
        return this.coref(this.docMaker.makeDocument(anno));
    }

    private static Map<Integer, CorefChain> makeCorefOutput(Document document) {
        Map<Integer, CorefChain> result = Generics.newHashMap();
        for (CorefCluster c : document.corefClusters.values()) {
            result.put(c.clusterID, new CorefChain(c, document.positions));
        }
        return result;
    }

    private static void postProcessing(Document document) {
        Set<Mention> removeSet = Generics.newHashSet();
        Set<Integer> removeClusterSet = Generics.newHashSet();
        for (CorefCluster c : document.corefClusters.values()) {
            Set<Mention> removeMentions = Generics.newHashSet();
            for (Mention m : c.getCorefMentions()) {
                if (!(m.appositions != null && m.appositions.size() > 0 || m.predicateNominatives != null && m.predicateNominatives.size() > 0) && (m.relativePronouns == null || m.relativePronouns.size() <= 0)) continue;
                removeMentions.add(m);
                removeSet.add(m);
                m.corefClusterID = m.mentionID;
            }
            c.corefMentions.removeAll(removeMentions);
            if (c.getCorefMentions().size() != 1) continue;
            removeClusterSet.add(c.clusterID);
        }
        Iterator<CorefCluster> iterator = removeClusterSet.iterator();
        while (iterator.hasNext()) {
            int removeId = (Integer)((Object)iterator.next());
            document.corefClusters.remove(removeId);
        }
        for (Mention m : removeSet) {
            document.positions.remove(m);
        }
    }

    private static void checkMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long memory = runtime.totalMemory() - runtime.freeMemory();
        log.info("USED MEMORY (bytes): " + memory);
    }

    public static void main(String[] args) throws Exception {
        Date startTime = new Date();
        System.err.printf("Start time: %s\n", startTime);
        HybridCorefSystem.runCoref(args);
        System.err.printf("Elapsed time: %.3f seconds\n", Float.valueOf((float)(new Date().getTime() - startTime.getTime()) / 1000.0f));
    }
}

