/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.neural;

import edu.stanford.nlp.coref.CorefDocumentProcessor;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.CorefUtils;
import edu.stanford.nlp.coref.data.CorefCluster;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.neural.CategoricalFeatureExtractor;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class NeuralCorefDataExporter
implements CorefDocumentProcessor {
    private final boolean conll;
    private final PrintWriter dataWriter;
    private final PrintWriter goldClusterWriter;
    private final Dictionaries dictionaries;

    public NeuralCorefDataExporter(Properties props, Dictionaries dictionaries, String dataPath, String goldClusterPath) {
        this.conll = CorefProperties.conll(props);
        this.dictionaries = dictionaries;
        try {
            this.dataWriter = IOUtils.getPrintWriter(dataPath);
            this.goldClusterWriter = IOUtils.getPrintWriter(goldClusterPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating data exporter", e);
        }
    }

    @Override
    public void process(int id, Document document) {
        JsonArrayBuilder clusters = Json.createArrayBuilder();
        for (CorefCluster gold : document.goldCorefClusters.values()) {
            JsonArrayBuilder c = Json.createArrayBuilder();
            for (Mention m : gold.corefMentions) {
                c.add(m.mentionID);
            }
            clusters.add((JsonValue)c.build());
        }
        this.goldClusterWriter.println(Json.createObjectBuilder().add(String.valueOf(id), (JsonValue)clusters.build()).build());
        Map<Pair<Integer, Integer>, Boolean> mentionPairs = CorefUtils.getLabeledMentionPairs(document);
        List<Mention> mentionsList = CorefUtils.getSortedMentions(document);
        HashMap<Integer, List> mentionsByHeadIndex = new HashMap<Integer, List>();
        for (Mention m : mentionsList) {
            List withIndex = mentionsByHeadIndex.computeIfAbsent(m.headIndex, k -> new ArrayList());
            withIndex.add(m);
        }
        JsonObjectBuilder docFeatures = Json.createObjectBuilder();
        docFeatures.add("doc_id", id);
        docFeatures.add("type", document.docType == Document.DocType.ARTICLE ? 1 : 0);
        docFeatures.add("source", document.docInfo.get("DOC_ID").split("/")[0]);
        JsonArrayBuilder sentences = Json.createArrayBuilder();
        for (Object sentence : (List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            sentences.add((JsonValue)NeuralCorefDataExporter.getSentenceArray((List)sentence.get(CoreAnnotations.TokensAnnotation.class)));
        }
        JsonObjectBuilder mentions = Json.createObjectBuilder();
        for (Mention m : document.predictedMentionsByID.values()) {
            Iterator<SemanticGraphEdge> iterator = m.enhancedDependency.incomingEdgeIterator(m.headIndexedWord);
            SemanticGraphEdge relation = iterator.hasNext() ? iterator.next() : null;
            String string = relation == null ? "no-parent" : relation.getRelation().toString();
            String depParent = relation == null ? "<missing>" : relation.getSource().word();
            mentions.add(String.valueOf(m.mentionNum), (JsonValue)Json.createObjectBuilder().add("doc_id", id).add("mention_id", m.mentionID).add("mention_num", m.mentionNum).add("sent_num", m.sentNum).add("start_index", m.startIndex).add("end_index", m.endIndex).add("head_index", m.headIndex).add("mention_type", m.mentionType.toString()).add("dep_relation", string).add("dep_parent", depParent).add("sentence", (JsonValue)NeuralCorefDataExporter.getSentenceArray(m.sentenceWords)).add("contained-in-other-mention", ((List)mentionsByHeadIndex.get(m.headIndex)).stream().anyMatch(m2 -> m != m2 && m.insideIn((Mention)m2)) ? 1 : 0).build());
        }
        JsonArrayBuilder featureNames = Json.createArrayBuilder().add("same-speaker").add("antecedent-is-mention-speaker").add("mention-is-antecedent-speaker").add("relaxed-head-match").add("exact-string-match").add("relaxed-string-match");
        JsonObjectBuilder features = Json.createObjectBuilder();
        JsonObjectBuilder labels = Json.createObjectBuilder();
        for (Map.Entry entry : mentionPairs.entrySet()) {
            Mention m1 = document.predictedMentionsByID.get(((Pair)entry.getKey()).first);
            Mention m22 = document.predictedMentionsByID.get(((Pair)entry.getKey()).second);
            String key = m1.mentionNum + " " + m22.mentionNum;
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (int val : CategoricalFeatureExtractor.pairwiseFeatures(document, m1, m22, this.dictionaries)) {
                builder.add(val);
            }
            features.add(key, (JsonValue)builder.build());
            labels.add(key, (Boolean)entry.getValue() != false ? 1 : 0);
        }
        JsonObject docData = Json.createObjectBuilder().add("sentences", (JsonValue)sentences.build()).add("mentions", (JsonValue)mentions.build()).add("labels", (JsonValue)labels.build()).add("pair_feature_names", (JsonValue)featureNames.build()).add("pair_features", (JsonValue)features.build()).add("document_features", (JsonValue)docFeatures.build()).build();
        this.dataWriter.println(docData);
    }

    @Override
    public void finish() throws Exception {
        this.dataWriter.close();
        this.goldClusterWriter.close();
    }

    private static JsonArray getSentenceArray(List<CoreLabel> sentence) {
        JsonArrayBuilder sentenceBuilder = Json.createArrayBuilder();
        sentence.stream().map(CoreLabel::word).map(w -> w.equals("/.") ? "." : w).map(w -> w.equals("/?") ? "?" : w).forEach(arg_0 -> ((JsonArrayBuilder)sentenceBuilder).add(arg_0));
        return sentenceBuilder.build();
    }

    public static void exportData(String outputPath, CorefProperties.Dataset dataset, Properties props, Dictionaries dictionaries) throws Exception {
        CorefProperties.setInput(props, dataset);
        String dataPath = outputPath + "/data_raw/";
        String goldClusterPath = outputPath + "/gold/";
        IOUtils.ensureDir(new File(outputPath));
        IOUtils.ensureDir(new File(dataPath));
        IOUtils.ensureDir(new File(goldClusterPath));
        new NeuralCorefDataExporter(props, dictionaries, dataPath + dataset.toString().toLowerCase(), goldClusterPath + dataset.toString().toLowerCase()).run(props, dictionaries);
    }

    public static void main(String[] args) throws Exception {
        String outputPath;
        Properties props;
        if (args.length == 2 && !args[0].startsWith("-")) {
            props = StringUtils.argsToProperties("-props", args[0]);
            outputPath = args[1];
        } else {
            props = StringUtils.argsToProperties(args);
            outputPath = props.getProperty("outputPath");
        }
        Dictionaries dictionaries = new Dictionaries(props);
        NeuralCorefDataExporter.exportData(outputPath, CorefProperties.Dataset.TRAIN, props, dictionaries);
        NeuralCorefDataExporter.exportData(outputPath, CorefProperties.Dataset.DEV, props, dictionaries);
        NeuralCorefDataExporter.exportData(outputPath, CorefProperties.Dataset.TEST, props, dictionaries);
    }
}

