/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.CoreEntityMention;
import edu.stanford.nlp.util.AcronymMatcher;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class KBPBasicSpanishCorefSystem {
    public static final String NER_PERSON = "PERSON";
    public static final String NER_ORGANIZATION = "ORGANIZATION";
    public static final Set<String> CORPORATE_SUFFIXES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("cic");
            this.add("cio");
            this.add("general partnership");
            this.add("llp");
            this.add("llp.");
            this.add("limited liability partnership");
            this.add("lp");
            this.add("lp.");
            this.add("limited partnership");
            this.add("ltd");
            this.add("ltd.");
            this.add("plc");
            this.add("plc.");
            this.add("private company limited by guarantee");
            this.add("unlimited company");
            this.add("sole proprietorship");
            this.add("sole trader");
            this.add("na");
            this.add("nt&sa");
            this.add("federal credit union");
            this.add("federal savings bank");
            this.add("lllp");
            this.add("lllp.");
            this.add("llc");
            this.add("llc.");
            this.add("lc");
            this.add("lc.");
            this.add("ltd");
            this.add("ltd.");
            this.add("co");
            this.add("co.");
            this.add("pllc");
            this.add("pllc.");
            this.add("corp");
            this.add("corp.");
            this.add("inc");
            this.add("inc.");
            this.add("pc");
            this.add("p.c.");
            this.add("dba");
            this.add("corporation");
            this.add("incorporated");
            this.add("limited");
            this.add("association");
            this.add("company");
            this.add("clib");
            this.add("syndicate");
            this.add("institute");
            this.add("fund");
            this.add("foundation");
            this.add("club");
            this.add("partners");
        }
    });

    public List<CoreEntityMention> wrapEntityMentions(List<CoreMap> entityMentions) {
        return entityMentions.stream().map(em -> new CoreEntityMention(null, (CoreMap)em)).collect(Collectors.toList());
    }

    protected String stripCorporateTitles(String input) {
        for (String suffix : CORPORATE_SUFFIXES) {
            if (!input.toLowerCase().endsWith(suffix)) continue;
            return input.substring(0, input.length() - suffix.length()).trim();
        }
        return input;
    }

    public String noSpecialChars(String original) {
        char[] chars = original.toCharArray();
        int size = 0;
        boolean isAllLowerCase = true;
        for (char aChar : chars) {
            if (aChar == '\\' || aChar == '\"' || aChar == '-') continue;
            if (isAllLowerCase && !Character.isLowerCase(aChar)) {
                isAllLowerCase = false;
            }
            ++size;
        }
        if (size == chars.length && isAllLowerCase) {
            return original;
        }
        char[] out2 = new char[size];
        int i = 0;
        for (char aChar : chars) {
            if (aChar == '\\' || aChar == '\"' || aChar == '-') continue;
            out2[i] = Character.toLowerCase(aChar);
            ++i;
        }
        return new String(out2);
    }

    public boolean moreCanonicalMention(CoreMap entityMention, CoreMap potentialCanonicalMention) {
        String entityMentionText = (String)entityMention.get(CoreAnnotations.TextAnnotation.class);
        String potentialCanonicalMentionText = (String)potentialCanonicalMention.get(CoreAnnotations.TextAnnotation.class);
        int entityMentionStart = (Integer)entityMention.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        int potentialCanonicalMentionStart = (Integer)potentialCanonicalMention.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (potentialCanonicalMentionText.length() > entityMentionText.length()) {
            return true;
        }
        return potentialCanonicalMentionText.length() == entityMentionText.length() && potentialCanonicalMentionStart < entityMentionStart;
    }

    public boolean firstNameMatch(String firstNameOne, String firstNameTwo) {
        return Math.min(firstNameOne.length(), firstNameTwo.length()) >= 5 && StringUtils.levenshteinDistance(firstNameOne, firstNameTwo) < 3;
    }

    protected boolean sameEntityWithoutLinking(CoreEntityMention emOne, CoreEntityMention emTwo) {
        double matchScore;
        String type = emOne.entityType();
        if (type.equals(NER_PERSON) && emOne.tokens().size() >= 2 && emTwo.tokens().size() >= 2 && emOne.tokens().get(emOne.tokens().size() - 1).word().toLowerCase().equals(emTwo.tokens().get(emTwo.tokens().size() - 1).word().toLowerCase())) {
            String firstNameTwo;
            String firstNameOne = emOne.tokens().get(0).word().toLowerCase();
            if (this.firstNameMatch(firstNameOne, firstNameTwo = emTwo.tokens().get(0).word().toLowerCase())) {
                return true;
            }
            if (emOne.tokens().size() == 2 && emTwo.tokens().size() == 2) {
                return false;
            }
        }
        if ((matchScore = Math.max(this.approximateEntityMatchScore(emOne.text(), emTwo.text()), this.approximateEntityMatchScore(emTwo.text(), emOne.text()))) == 1.0) {
            return true;
        }
        if (matchScore < 0.34) {
            return false;
        }
        if (type.equals(NER_PERSON) && matchScore > 0.49) {
            if (Math.min(emOne.text().length(), emTwo.text().length()) > 1) {
                if (emOne.tokens().size() == 1 && emTwo.tokens().size() > 1 && emTwo.tokens().get(emTwo.tokens().size() - 1).word().equalsIgnoreCase(emOne.tokens().get(0).word()) || emTwo.tokens().size() == 1 && emOne.tokens().size() > 1 && emOne.tokens().get(emOne.tokens().size() - 1).word().equalsIgnoreCase(emTwo.tokens().get(0).word())) {
                    return true;
                }
                if (emOne.tokens().size() == 1 && emTwo.tokens().size() > 1 && emTwo.tokens().get(0).word().equalsIgnoreCase(emOne.tokens().get(0).word()) || emTwo.tokens().size() == 1 && emOne.tokens().size() > 1 && emOne.tokens().get(0).word().equalsIgnoreCase(emTwo.tokens().get(0).word())) {
                    return true;
                }
            }
            if (matchScore > 0.65) {
                return true;
            }
        }
        return type == NER_ORGANIZATION && matchScore > 0.79;
    }

    private boolean nearExactEntityMatch(String higherGloss, String lowerGloss) {
        if (higherGloss.equalsIgnoreCase(lowerGloss)) {
            return true;
        }
        return this.noSpecialChars(higherGloss).equalsIgnoreCase(this.noSpecialChars(lowerGloss));
    }

    public double approximateEntityMatchScore(String higherGloss, String lowerGloss) {
        String[] lowerToks;
        if (this.nearExactEntityMatch(higherGloss, lowerGloss)) {
            return 1.0;
        }
        String[] higherToks = this.stripCorporateTitles(higherGloss).split("\\s+");
        if (AcronymMatcher.isAcronym(higherToks, lowerToks = this.stripCorporateTitles(lowerGloss).split("\\s+"))) {
            return 1.0;
        }
        int match = 0;
        boolean[] matchedHigherToks = new boolean[higherToks.length];
        boolean[] matchedLowerToks = new boolean[lowerToks.length];
        for (int h = 0; h < higherToks.length; ++h) {
            if (matchedHigherToks[h]) continue;
            String higherTok = higherToks[h];
            String higherTokNoSpecialChars = this.noSpecialChars(higherTok);
            boolean doesMatch = false;
            for (int l = 0; l < lowerToks.length; ++l) {
                if (matchedLowerToks[l]) continue;
                String lowerTok = lowerToks[l];
                String lowerTokNoSpecialCars = this.noSpecialChars(lowerTok);
                int minLength = Math.min(lowerTokNoSpecialCars.length(), higherTokNoSpecialChars.length());
                if (!higherTokNoSpecialChars.equalsIgnoreCase(lowerTokNoSpecialCars) && (minLength <= 5 || !higherTokNoSpecialChars.endsWith(lowerTokNoSpecialCars) && !higherTokNoSpecialChars.startsWith(lowerTokNoSpecialCars)) && (minLength <= 5 || !lowerTokNoSpecialCars.endsWith(higherTokNoSpecialChars) && !lowerTokNoSpecialCars.startsWith(higherTokNoSpecialChars)) && (minLength <= 5 || StringUtils.levenshteinDistance(lowerTokNoSpecialCars, higherTokNoSpecialChars) > 1)) continue;
                doesMatch = true;
                matchedHigherToks[h] = true;
                matchedLowerToks[l] = true;
            }
            if (!doesMatch) continue;
            ++match;
        }
        return (double)match / (double)Math.max(higherToks.length, lowerToks.length);
    }

    public List<List<CoreMap>> clusterEntityMentions(List<CoreMap> entityMentions) {
        List<CoreEntityMention> wrappedEntityMentions = this.wrapEntityMentions(entityMentions);
        ArrayList entityMentionClusters = new ArrayList();
        for (CoreEntityMention newEM : wrappedEntityMentions) {
            boolean bl = false;
            for (ArrayList arrayList : entityMentionClusters) {
                for (CoreEntityMention clusterEM : arrayList) {
                    if (!this.sameEntityWithoutLinking(newEM, clusterEM)) continue;
                    arrayList.add(newEM);
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (bl) continue;
            ArrayList<CoreEntityMention> newCluster = new ArrayList<CoreEntityMention>();
            newCluster.add(newEM);
            entityMentionClusters.add(newCluster);
        }
        ArrayList<List<CoreMap>> coreMapEntityMentionClusters = new ArrayList<List<CoreMap>>();
        for (ArrayList arrayList : entityMentionClusters) {
            List coreMapCluster = arrayList.stream().map(coreEM -> coreEM.coreMap()).collect(Collectors.toList());
            coreMapEntityMentionClusters.add(coreMapCluster);
        }
        return coreMapEntityMentionClusters;
    }

    public CoreMap bestEntityMention(List<CoreMap> entityMentionCluster) {
        CoreMap bestEntityMention = null;
        for (CoreMap candidateEntityMention : entityMentionCluster) {
            if (bestEntityMention == null) {
                bestEntityMention = candidateEntityMention;
                continue;
            }
            if (((String)candidateEntityMention.get(CoreAnnotations.TextAnnotation.class)).length() > ((String)bestEntityMention.get(CoreAnnotations.TextAnnotation.class)).length()) {
                bestEntityMention = candidateEntityMention;
                continue;
            }
            if (((String)candidateEntityMention.get(CoreAnnotations.TextAnnotation.class)).length() != ((String)bestEntityMention.get(CoreAnnotations.TextAnnotation.class)).length() || (Integer)candidateEntityMention.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) >= (Integer)bestEntityMention.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) continue;
            bestEntityMention = candidateEntityMention;
        }
        return bestEntityMention;
    }

    public Map<CoreMap, CoreMap> createCanonicalMentionMap(List<List<CoreMap>> entityMentionClusters) {
        HashMap<CoreMap, CoreMap> canonicalMentionMap = new HashMap<CoreMap, CoreMap>();
        for (List<CoreMap> entityMentionCluster : entityMentionClusters) {
            CoreMap bestEntityMention = this.bestEntityMention(entityMentionCluster);
            for (CoreMap clusterEntityMention : entityMentionCluster) {
                canonicalMentionMap.put(clusterEntityMention, bestEntityMention);
            }
        }
        return canonicalMentionMap;
    }

    public Map<CoreMap, CoreMap> canonicalMentionMapFromEntityMentions(List<CoreMap> entityMentions) {
        List<List<CoreMap>> entityMentionClusters = this.clusterEntityMentions(entityMentions);
        return this.createCanonicalMentionMap(entityMentionClusters);
    }
}

