/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunction;
import edu.stanford.nlp.ie.crf.CliquePotentialFunction;
import edu.stanford.nlp.ie.crf.NoisyLabelLinearCliquePotentialFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.util.Index;
import java.util.List;

public class CRFLogConditionalObjectiveFunctionNoisyLabel
extends CRFLogConditionalObjectiveFunction {
    protected final double[][] errorMatrix;

    CRFLogConditionalObjectiveFunctionNoisyLabel(int[][][][] data, int[][] labels, int window, Index<String> classIndex, List<Index<CRFLabel>> labelIndices, int[] map, String priorType, String backgroundSymbol, double sigma, double[][][][] featureVal, int multiThreadGrad, double[][] errorMatrix) {
        super(data, labels, window, classIndex, labelIndices, map, priorType, backgroundSymbol, sigma, featureVal, multiThreadGrad, false);
        this.errorMatrix = errorMatrix;
    }

    public CliquePotentialFunction getFunc(int docIndex) {
        int[] docLabels = this.labels[docIndex];
        return new NoisyLabelLinearCliquePotentialFunction(this.weights, docLabels, this.errorMatrix);
    }

    @Override
    public void setWeights(double[][] weights) {
        super.setWeights(weights);
    }

    @Override
    protected double expectedAndEmpiricalCountsAndValueForADoc(double[][] E, double[][] Ehat, int docIndex) {
        int[][][] docData = this.data[docIndex];
        double[][][] featureVal3DArr = null;
        if (this.featureVal != null) {
            featureVal3DArr = this.featureVal[docIndex];
        }
        CRFCliqueTree<String> cliqueTreeNoisyLabel = CRFCliqueTree.getCalibratedCliqueTree(docData, this.labelIndices, this.numClasses, this.classIndex, this.backgroundSymbol, this.getFunc(docIndex), featureVal3DArr);
        CRFCliqueTree<String> cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(docData, this.labelIndices, this.numClasses, this.classIndex, this.backgroundSymbol, this.cliquePotentialFunc, featureVal3DArr);
        double prob = cliqueTreeNoisyLabel.totalMass() - cliqueTree.totalMass();
        this.documentExpectedCounts(E, docData, featureVal3DArr, cliqueTree);
        this.documentExpectedCounts(Ehat, docData, featureVal3DArr, cliqueTreeNoisyLabel);
        return prob;
    }

    @Override
    protected double regularGradientAndValue() {
        return this.multiThreadGradient(ArrayMath.range(this.data.length), true);
    }

    @Override
    public void calculate(double[] x) {
        CRFLogConditionalObjectiveFunctionNoisyLabel.clear2D(this.Ehat);
        super.calculate(x);
    }
}

