/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CliquePotentialFunction;

public class LinearCliquePotentialFunction
implements CliquePotentialFunction {
    private final float[][] fWeights;
    private final double[][] dWeights;

    LinearCliquePotentialFunction(float[][] weights) {
        this.fWeights = weights;
        this.dWeights = null;
    }

    LinearCliquePotentialFunction(double[][] weights) {
        this.fWeights = null;
        this.dWeights = weights;
    }

    @Override
    public double computeCliquePotential(int cliqueSize, int labelIndex, int[] cliqueFeatures, double[] featureVal, int posInSent) {
        double output = 0.0;
        for (int m = 0; m < cliqueFeatures.length; ++m) {
            double dotProd;
            double d = dotProd = this.fWeights == null ? this.dWeights[cliqueFeatures[m]][labelIndex] : (double)this.fWeights[cliqueFeatures[m]][labelIndex];
            if (featureVal != null) {
                dotProd *= featureVal[m];
            }
            output += dotProd;
        }
        return output;
    }
}

