/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.qe;

import edu.stanford.nlp.ie.NumberNormalizer;
import edu.stanford.nlp.ie.qe.Options;
import edu.stanford.nlp.ie.qe.SimpleQuantifiableEntity;
import edu.stanford.nlp.ie.qe.Unit;
import edu.stanford.nlp.ie.qe.UnitPrefix;
import edu.stanford.nlp.ie.qe.Units;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class QuantifiableEntityExtractor {
    private Env env;
    private Options options;
    private CoreMapExpressionExtractor<MatchedExpression> extractor;

    public SimpleQuantifiableEntity get(double amount, String unitName) {
        return new SimpleQuantifiableEntity(amount, (Unit)this.env.get(unitName));
    }

    public List<MatchedExpression> extract(CoreMap annotation) {
        if (!annotation.containsKey(CoreAnnotations.NumerizedTokensAnnotation.class)) {
            List<CoreMap> mergedNumbers = NumberNormalizer.findAndMergeNumbers(annotation);
            annotation.set(CoreAnnotations.NumerizedTokensAnnotation.class, mergedNumbers);
        }
        return this.extractor.extractExpressions(annotation);
    }

    public void init(String name, Properties props) {
        this.init(new Options(name, props));
    }

    public void init(Options options) {
        this.options = options;
        this.initEnv();
        this.extractor = this.createExtractor();
    }

    private CoreMapExpressionExtractor<MatchedExpression> createExtractor() {
        List<String> filenames = StringUtils.split(this.options.grammarFilename, "\\s*[,;]\\s*");
        return CoreMapExpressionExtractor.createExtractorFromFiles(this.env, filenames);
    }

    private void initEnv() {
        this.env = TokenSequencePattern.getNewEnv();
        this.env.setDefaultTokensAnnotationKey(CoreAnnotations.NumerizedTokensAnnotation.class);
        this.env.setDefaultStringMatchFlags(66);
        this.env.setDefaultStringPatternFlags(66);
        try {
            Units.registerUnits(this.env, this.options.unitsFilename);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error loading units from " + this.options.unitsFilename, ex);
        }
        try {
            UnitPrefix.registerPrefixes(this.env, this.options.prefixFilename);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error loading prefixes from " + this.options.prefixFilename, ex);
        }
        this.env.bind("options", this.options);
        this.env.bind("numcomptype", CoreAnnotations.NumericCompositeTypeAnnotation.class);
        this.env.bind("numcompvalue", CoreAnnotations.NumericCompositeValueAnnotation.class);
    }

    private static void generatePrefixDefs(String infile, String outfile) throws IOException {
        List<UnitPrefix> prefixes = UnitPrefix.loadPrefixes(infile);
        PrintWriter pw = IOUtils.getPrintWriter(outfile);
        pw.println("SI_PREFIX_MAP = {");
        ArrayList<String> items = new ArrayList<String>();
        for (UnitPrefix prefix : prefixes) {
            if (!"SI".equals(prefix.system)) continue;
            items.add("\"" + prefix.name + "\": " + prefix.getName().toUpperCase());
        }
        pw.println(StringUtils.join(items, ",\n"));
        pw.println("}");
        pw.println("$SiPrefixes = CreateRegex(Keys(SI_PREFIX_MAP))");
        pw.println();
        pw.println("SI_SYM_PREFIX_MAP = {");
        items.clear();
        for (UnitPrefix prefix : prefixes) {
            if (!"SI".equals(prefix.system)) continue;
            items.add("\"" + prefix.symbol + "\": " + prefix.getName().toUpperCase());
        }
        pw.println(StringUtils.join(items, ",\n"));
        pw.println("}");
        pw.println("$SiSymPrefixes = CreateRegex(Keys(SI_SYM_PREFIX_MAP))");
        pw.close();
    }

    private static void generateUnitsStage0Rules(String unitsFiles, String infile, String outfile) throws IOException {
        String line;
        Pattern tabPattern = Pattern.compile("\t");
        PrintWriter pw = IOUtils.getPrintWriter(outfile);
        List<Unit> units = Units.loadUnits(unitsFiles);
        pw.println("SI_UNIT_MAP = {");
        ArrayList<String> items = new ArrayList<String>();
        for (Unit unit : units) {
            if (!"SI".equals(unit.prefixSystem)) continue;
            items.add("\"" + unit.name + "\": " + (unit.getType() + "_" + unit.getName()).toUpperCase());
        }
        pw.println(StringUtils.join(items, ",\n"));
        pw.println("}");
        pw.println("$SiUnits = CreateRegex(Keys(SI_UNIT_MAP))");
        pw.println();
        pw.println("SI_SYM_UNIT_MAP = {");
        items.clear();
        for (Unit unit : units) {
            if (!"SI".equals(unit.prefixSystem)) continue;
            items.add("\"" + unit.symbol + "\": " + (unit.getType() + "_" + unit.getName()).toUpperCase());
        }
        pw.println(StringUtils.join(items, ",\n"));
        pw.println("}");
        pw.println("$SiSymUnits = CreateRegex(Keys(SI_SYM_UNIT_MAP))");
        pw.println();
        pw.println("SYM_UNIT_MAP = {");
        items.clear();
        for (Unit unit : units) {
            items.add("\"" + unit.symbol + "\": " + (unit.getType() + "_" + unit.getName()).toUpperCase());
        }
        pw.println(StringUtils.join(items, ",\n"));
        pw.println("}");
        pw.println("$SymUnits = CreateRegex(Keys(SYM_UNIT_MAP))");
        pw.println();
        BufferedReader br = IOUtils.readerFromString(infile);
        pw.println("ENV.defaults[\"stage\"] = 0");
        while ((line = br.readLine()) != null) {
            String[] fields = tabPattern.split(line);
            pw.println(String.format("{ pattern: ( %s ), action: Tag($0, \"Unit\", %s) }", fields[0], fields[1]));
        }
        br.close();
        pw.close();
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        Options options = new Options("qe", props);
        QuantifiableEntityExtractor.generatePrefixDefs(options.prefixFilename, options.prefixRulesFilename);
        QuantifiableEntityExtractor.generateUnitsStage0Rules(options.unitsFilename, options.text2UnitMapping, options.unitsRulesFilename);
    }
}

