/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.german.process;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.CoreLabelProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;

public class GermanTokenizerPostProcessor
extends CoreLabelProcessor {
    public Function<CoreLabel, Boolean> afterIsEmpty = tok -> tok.containsKey(CoreAnnotations.AfterAnnotation.class) && tok.after().equals("");
    public HashSet<String> ordinalPredictingWords = new HashSet<String>(Arrays.asList("Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember", "Jahrhundert"));
    public HashSet<String> germanAbbreviations = new HashSet<String>(Arrays.asList("bzw", "jap", "usw", "ca"));

    public static void mergeTokens(CoreLabel token, CoreLabel nextToken) {
        token.setWord(token.word() + nextToken.word());
        token.setAfter(nextToken.after());
        token.setEndPosition(nextToken.endPosition());
        token.setValue(token.word() + "-" + token.sentIndex());
    }

    @Override
    public List<CoreLabel> process(List<CoreLabel> tokens) {
        ArrayList<CoreLabel> processedTokens = new ArrayList<CoreLabel>();
        if (tokens.size() > 0) {
            processedTokens.add(tokens.get(0));
        }
        for (int i = 1; i < tokens.size(); ++i) {
            boolean abbreviationMerge;
            CoreLabel currToken = tokens.get(i);
            CoreLabel lastProcessedToken = (CoreLabel)processedTokens.get(processedTokens.size() - 1);
            boolean emptyAfter = this.afterIsEmpty.apply(lastProcessedToken);
            boolean ordinalMerge = lastProcessedToken.word().matches("[0-9]+") && currToken.word().equals(".") && i + 1 < tokens.size() && this.ordinalPredictingWords.contains(tokens.get(i + 1).word());
            boolean numberToHyphenMerge = lastProcessedToken.word().matches("[0-9]+") && currToken.word().equals("-") && i + 1 < tokens.size() && tokens.get(i + 1).word().matches("[0-9]+");
            boolean hyphenToNumberMerge = lastProcessedToken.word().matches("[0-9]+-") && currToken.word().matches("[0-9]+");
            boolean bl = abbreviationMerge = this.germanAbbreviations.contains(lastProcessedToken.word()) && currToken.word().equals(".");
            if (emptyAfter && (ordinalMerge || numberToHyphenMerge || hyphenToNumberMerge || abbreviationMerge)) {
                GermanTokenizerPostProcessor.mergeTokens(lastProcessedToken, currToken);
                continue;
            }
            processedTokens.add(currToken);
        }
        return processedTokens;
    }

    @Override
    public List<CoreLabel> restore(List<CoreLabel> originalTokens, List<CoreLabel> processedTokens) {
        return originalTokens;
    }
}

