/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.TwoDimensionalMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class AnnotationSerializer {
    public abstract OutputStream write(Annotation var1, OutputStream var2) throws IOException;

    public abstract Pair<Annotation, InputStream> read(InputStream var1) throws IOException, ClassNotFoundException, ClassCastException;

    public OutputStream writeCoreDocument(CoreDocument document, OutputStream os) throws IOException {
        Annotation wrappedAnnotation = document.annotation();
        return this.write(wrappedAnnotation, os);
    }

    public Pair<CoreDocument, InputStream> readCoreDocument(InputStream is) throws IOException, ClassNotFoundException, ClassCastException {
        Pair<Annotation, InputStream> readPair = this.read(is);
        CoreDocument readCoreDocument = new CoreDocument(readPair.first());
        return new Pair<CoreDocument, InputStream>(readCoreDocument, is);
    }

    public static class IntermediateSemanticGraph {
        public List<IntermediateNode> nodes;
        public List<IntermediateEdge> edges;
        private static final Object LOCK = new Object();

        public IntermediateSemanticGraph() {
            this.nodes = new ArrayList<IntermediateNode>();
            this.edges = new ArrayList<IntermediateEdge>();
        }

        public IntermediateSemanticGraph(List<IntermediateNode> nodes, List<IntermediateEdge> edges) {
            this.nodes = new ArrayList<IntermediateNode>(nodes);
            this.edges = new ArrayList<IntermediateEdge>(edges);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SemanticGraph convertIntermediateGraph(List<CoreLabel> sentence) {
            SemanticGraph graph = new SemanticGraph();
            TwoDimensionalMap<Integer, Integer, IndexedWord> nodeMap = TwoDimensionalMap.hashMap();
            for (IntermediateNode in : this.nodes) {
                IndexedWord word;
                CoreLabel token = sentence.get(in.index - 1);
                if (in.copyAnnotation > 0) {
                    word = new IndexedWord(new CoreLabel(token));
                    word.setCopyCount(in.copyAnnotation);
                } else {
                    word = new IndexedWord(token);
                }
                if (word.docID() == null && in.docId != null) {
                    word.setDocID(in.docId);
                }
                if (word.sentIndex() < 0 && in.sentIndex >= 0) {
                    word.setSentIndex(in.sentIndex);
                }
                if (word.index() < 0 && in.index >= 0) {
                    word.setIndex(in.index);
                }
                nodeMap.put(word.index(), word.copyCount(), word);
                graph.addVertex(word);
                if (!in.isRoot) continue;
                graph.addRoot(word);
            }
            for (IntermediateEdge ie : this.edges) {
                IndexedWord source = (IndexedWord)nodeMap.get(ie.source, ie.sourceCopy);
                if (source == null) {
                    throw new RuntimeIOException("Failed to find node " + ie.source + "-" + ie.sourceCopy);
                }
                IndexedWord target = (IndexedWord)nodeMap.get(ie.target, ie.targetCopy);
                if (target == null) {
                    throw new RuntimeIOException("Failed to find node " + ie.target + "-" + ie.targetCopy);
                }
                Object object = LOCK;
                synchronized (object) {
                    GrammaticalRelation rel = GrammaticalRelation.valueOf(ie.dep);
                    graph.addEdge(source, target, rel, 1.0, ie.isExtra);
                }
            }
            if (!graph.isEmpty() && graph.getRoots().isEmpty()) {
                graph.resetRoots();
            }
            return graph;
        }
    }

    public static class IntermediateEdge {
        int source;
        int sourceCopy;
        int target;
        int targetCopy;
        String dep;
        boolean isExtra;

        public IntermediateEdge(String dep, int source, int sourceCopy, int target, int targetCopy, boolean isExtra) {
            this.dep = dep;
            this.source = source;
            this.sourceCopy = sourceCopy;
            this.target = target;
            this.targetCopy = targetCopy;
            this.isExtra = isExtra;
        }
    }

    public static class IntermediateNode {
        String docId;
        int sentIndex;
        int index;
        int copyAnnotation;
        boolean isRoot;

        public IntermediateNode(String docId, int sentIndex, int index, int copy, boolean isRoot) {
            this.docId = docId;
            this.sentIndex = sentIndex;
            this.index = index;
            this.copyAnnotation = copy;
            this.isRoot = isRoot;
        }
    }
}

