/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.CoreEntityMention;
import edu.stanford.nlp.pipeline.CoreSentence;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CoreQuote {
    private final CoreMap quoteCoreMap;
    private final CoreDocument document;
    private final List<CoreSentence> sentences;
    public boolean hasSpeaker;
    public boolean hasCanonicalSpeaker;
    private Optional<String> speaker;
    private Optional<String> canonicalSpeaker;
    private Optional<List<CoreLabel>> speakerTokens;
    private Optional<List<CoreLabel>> canonicalSpeakerTokens;
    private Optional<Pair<Integer, Integer>> speakerCharOffsets;
    private Optional<Pair<Integer, Integer>> canonicalSpeakerCharOffsets;
    private Optional<CoreEntityMention> speakerEntityMention;
    private Optional<CoreEntityMention> canonicalSpeakerEntityMention;

    public CoreQuote(CoreDocument myDocument, CoreMap coreMapQuote) {
        this.document = myDocument;
        this.quoteCoreMap = coreMapQuote;
        this.sentences = new ArrayList<CoreSentence>();
        int firstSentenceIndex = (Integer)this.quoteCoreMap.get(CoreAnnotations.SentenceBeginAnnotation.class);
        int lastSentenceIndex = (Integer)this.quoteCoreMap.get(CoreAnnotations.SentenceEndAnnotation.class);
        for (int currSentIndex = firstSentenceIndex; currSentIndex <= lastSentenceIndex; ++currSentIndex) {
            this.sentences.add(this.document.sentences().get(currSentIndex));
        }
        this.speaker = Optional.ofNullable(this.quoteCoreMap.get(QuoteAttributionAnnotator.SpeakerAnnotation.class));
        this.canonicalSpeaker = Optional.ofNullable(this.quoteCoreMap.get(QuoteAttributionAnnotator.CanonicalMentionAnnotation.class));
        Integer firstSpeakerTokenIndex = (Integer)this.quoteCoreMap.get(QuoteAttributionAnnotator.MentionBeginAnnotation.class);
        Integer lastSpeakerTokenIndex = (Integer)this.quoteCoreMap.get(QuoteAttributionAnnotator.MentionEndAnnotation.class);
        this.speakerTokens = Optional.empty();
        this.speakerCharOffsets = Optional.empty();
        this.speakerEntityMention = Optional.empty();
        if (firstSpeakerTokenIndex != null && lastSpeakerTokenIndex != null) {
            this.speakerTokens = Optional.of(new ArrayList());
            for (int speakerTokenIndex = firstSpeakerTokenIndex.intValue(); speakerTokenIndex <= lastSpeakerTokenIndex; ++speakerTokenIndex) {
                this.speakerTokens.get().add(this.document.tokens().get(speakerTokenIndex));
            }
            int speakerCharOffsetBegin = (Integer)this.speakerTokens.get().get(0).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int speakerCharOffsetEnd = (Integer)this.speakerTokens.get().get(this.speakerTokens.get().size() - 1).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            this.speakerCharOffsets = Optional.of(new Pair<Integer, Integer>(speakerCharOffsetBegin, speakerCharOffsetEnd));
            for (CoreEntityMention candidateEntityMention : this.document.entityMentions()) {
                Pair<Integer, Integer> entityMentionOffsets = candidateEntityMention.charOffsets();
                if (!entityMentionOffsets.equals(this.speakerCharOffsets.get())) continue;
                this.speakerEntityMention = Optional.of(candidateEntityMention);
                break;
            }
        }
        Integer firstCanonicalSpeakerTokenIndex = (Integer)this.quoteCoreMap.get(QuoteAttributionAnnotator.CanonicalMentionBeginAnnotation.class);
        Integer lastCanonicalSpeakerTokenIndex = (Integer)this.quoteCoreMap.get(QuoteAttributionAnnotator.CanonicalMentionEndAnnotation.class);
        this.canonicalSpeakerTokens = Optional.empty();
        this.canonicalSpeakerCharOffsets = Optional.empty();
        this.canonicalSpeakerEntityMention = Optional.empty();
        if (firstCanonicalSpeakerTokenIndex != null && lastCanonicalSpeakerTokenIndex != null) {
            this.canonicalSpeakerTokens = Optional.of(new ArrayList());
            for (int canonicalSpeakerTokenIndex = firstCanonicalSpeakerTokenIndex.intValue(); canonicalSpeakerTokenIndex <= lastCanonicalSpeakerTokenIndex; ++canonicalSpeakerTokenIndex) {
                this.canonicalSpeakerTokens.get().add(this.document.tokens().get(canonicalSpeakerTokenIndex));
            }
            int canonicalSpeakerCharOffsetBegin = (Integer)this.canonicalSpeakerTokens.get().get(0).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int canonicalSpeakerCharOffsetEnd = (Integer)this.canonicalSpeakerTokens.get().get(this.canonicalSpeakerTokens.get().size() - 1).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            this.canonicalSpeakerCharOffsets = Optional.of(new Pair<Integer, Integer>(canonicalSpeakerCharOffsetBegin, canonicalSpeakerCharOffsetEnd));
            for (CoreEntityMention candidateEntityMention : this.document.entityMentions()) {
                Pair<Integer, Integer> entityMentionOffsets = candidateEntityMention.charOffsets();
                if (!entityMentionOffsets.equals(this.canonicalSpeakerCharOffsets.get())) continue;
                this.canonicalSpeakerEntityMention = Optional.of(candidateEntityMention);
                break;
            }
        }
        this.hasSpeaker = this.speaker.isPresent();
        this.hasCanonicalSpeaker = this.canonicalSpeaker.isPresent();
    }

    public CoreMap coreMap() {
        return this.quoteCoreMap;
    }

    public CoreDocument document() {
        return this.document;
    }

    public String text() {
        return (String)this.quoteCoreMap.get(CoreAnnotations.TextAnnotation.class);
    }

    public List<CoreSentence> sentences() {
        return this.sentences;
    }

    public Optional<String> speaker() {
        return this.speaker;
    }

    public Optional<String> canonicalSpeaker() {
        return this.canonicalSpeaker;
    }

    public Optional<List<CoreLabel>> speakerTokens() {
        return this.speakerTokens;
    }

    public Optional<Pair<Integer, Integer>> speakerCharOffsets() {
        return this.speakerCharOffsets;
    }

    public Optional<CoreEntityMention> speakerEntityMention() {
        return this.speakerEntityMention;
    }

    public Optional<List<CoreLabel>> canonicalSpeakerTokens() {
        return this.canonicalSpeakerTokens;
    }

    public Optional<Pair<Integer, Integer>> canonicalSpeakerCharOffsets() {
        return this.canonicalSpeakerCharOffsets;
    }

    public Optional<CoreEntityMention> canonicalSpeakerEntityMention() {
        return this.canonicalSpeakerEntityMention;
    }

    public Pair<Integer, Integer> quoteCharOffsets() {
        int beginCharOffset = (Integer)this.quoteCoreMap.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        int endCharOffset = (Integer)this.quoteCoreMap.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        return new Pair<Integer, Integer>(beginCharOffset, endCharOffset);
    }

    public String toString() {
        return this.coreMap().toString();
    }
}

