/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.CoreLabelProcessor;
import java.util.List;

public class CodepointCoreLabelProcessor
extends CoreLabelProcessor {
    private static int getTextCodepoints(CoreLabel label, Class<? extends CoreAnnotation<String>> annotation) {
        String text = (String)label.get(annotation);
        return Character.codePointCount(text, 0, text.length());
    }

    @Override
    public List<CoreLabel> process(List<CoreLabel> tokens) {
        int current = 0;
        for (CoreLabel label : tokens) {
            label.set(CoreAnnotations.CodepointOffsetBeginAnnotation.class, current += CodepointCoreLabelProcessor.getTextCodepoints(label, CoreAnnotations.BeforeAnnotation.class));
            label.set(CoreAnnotations.CodepointOffsetEndAnnotation.class, current += CodepointCoreLabelProcessor.getTextCodepoints(label, CoreAnnotations.OriginalTextAnnotation.class));
        }
        return tokens;
    }

    @Override
    public List<CoreLabel> restore(List<CoreLabel> originalTokens, List<CoreLabel> processedTokens) {
        for (CoreLabel label : processedTokens) {
            label.remove(CoreAnnotations.CodepointOffsetBeginAnnotation.class);
            label.remove(CoreAnnotations.CodepointOffsetEndAnnotation.class);
        }
        return processedTokens;
    }
}

