/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.Sieve;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.util.CoreMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class QMSieve
extends Sieve {
    protected static Set<String> beforeQuotePunctuation = new HashSet<String>(Arrays.asList(",", ":"));
    protected static final SemgrexPattern subjVerbPattern = SemgrexPattern.compile("{pos:/VB.*/}=VERB >nsubj {}=SUBJ");
    protected static Set<String> commonSpeechWords = new HashSet<String>(Arrays.asList("say", "cry", "reply", "add", "think", "observe", "call", "answer", "tweet", "declare", "curse", "mutter", "post", "ask", "respond", "report", "tell", "announce", "suggest", "inquire", "enquire", "decide", "demand", "offer", "order", "propose", "request", "suggest", "wonder", "surmise", "exclaim", "mumble", "whisper"));
    protected String sieveName;

    public QMSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet, String sieveName) {
        super(doc, characterMap, pronounCorefMap, animacySet);
        this.sieveName = sieveName;
    }

    public abstract void doQuoteToMention(Annotation var1);

    public static void fillInMention(CoreMap quote, String text, int begin, int end, String sieveName, String mentionType) {
        quote.set(QuoteAttributionAnnotator.MentionAnnotation.class, text);
        quote.set(QuoteAttributionAnnotator.MentionBeginAnnotation.class, begin);
        quote.set(QuoteAttributionAnnotator.MentionEndAnnotation.class, end);
        quote.set(QuoteAttributionAnnotator.MentionSieveAnnotation.class, sieveName);
        quote.set(QuoteAttributionAnnotator.MentionTypeAnnotation.class, mentionType);
    }

    protected static void fillInMention(CoreMap quote, Sieve.MentionData md, String sieveName) {
        QMSieve.fillInMention(quote, md.text, md.begin, md.end, sieveName, md.type);
    }

    protected Sieve.MentionData getMentionData(CoreMap quote) {
        String text = (String)quote.get(QuoteAttributionAnnotator.MentionAnnotation.class);
        int begin = (Integer)quote.get(QuoteAttributionAnnotator.MentionBeginAnnotation.class);
        int end = (Integer)quote.get(QuoteAttributionAnnotator.MentionEndAnnotation.class);
        String type = (String)quote.get(QuoteAttributionAnnotator.MentionTypeAnnotation.class);
        return new Sieve.MentionData(begin, end, text, type);
    }
}

