/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.quoteattribution.ExtractQuotesClassifier;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.quoteattribution.Sieves.training.SupervisedSieveTraining;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SupervisedSieve
extends QMSieve {
    private ExtractQuotesClassifier quotesClassifier;

    public SupervisedSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacyList) {
        super(doc, characterMap, pronounCorefMap, animacyList, "supervised");
    }

    public void loadModel(String filename) {
        this.quotesClassifier = new ExtractQuotesClassifier(filename);
    }

    @Override
    public void doQuoteToMention(Annotation doc) {
        if (this.quotesClassifier == null) {
            throw new RuntimeException("need to do training first!");
        }
        SupervisedSieveTraining.FeaturesData fd = SupervisedSieveTraining.featurize(new SupervisedSieveTraining.SieveData(doc, this.characterMap, this.pronounCorefMap, this.animacySet), null, false);
        this.quotesClassifier.scoreBestMentionNew(fd, doc);
    }
}

