/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VocativeSieve
extends QMSieve {
    public VocativeSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet, "");
    }

    @Override
    public void doQuoteToMention(Annotation doc) {
        this.vocativeQuoteToMention(doc);
        this.oneSpeakerSentence(doc);
    }

    public void vocativeQuoteToMention(Annotation doc) {
        List toks = (List)doc.get(CoreAnnotations.TokensAnnotation.class);
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        block0: for (CoreMap quote : quotes) {
            Pair<Integer, Integer> quoteRun;
            CoreMap prevQuote;
            int prevParagraph;
            if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null) continue;
            int currQuoteIndex = (Integer)quote.get(CoreAnnotations.QuotationIndexAnnotation.class);
            int currParagraph = (Integer)((CoreMap)sentences.get((Integer)quote.get(CoreAnnotations.SentenceBeginAnnotation.class))).get(CoreAnnotations.ParagraphIndexAnnotation.class);
            ArrayList<CoreMap> quotesInPrevParagraph = new ArrayList<CoreMap>();
            for (int i = currQuoteIndex - 1; i >= 0 && (prevParagraph = ((Integer)((CoreMap)sentences.get((Integer)(prevQuote = (CoreMap)quotes.get(i)).get(CoreAnnotations.SentenceBeginAnnotation.class))).get(CoreAnnotations.ParagraphIndexAnnotation.class)).intValue()) + 1 == currParagraph; --i) {
                quotesInPrevParagraph.add(prevQuote);
            }
            if (quotesInPrevParagraph.size() == 0) continue;
            boolean vocativeFound = false;
            for (CoreMap prevQuote2 : quotesInPrevParagraph) {
                quoteRun = new Pair<Integer, Integer>((Integer)prevQuote2.get(CoreAnnotations.TokenBeginAnnotation.class), (Integer)prevQuote2.get(CoreAnnotations.TokenEndAnnotation.class));
                Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>> nameAndIndices = this.scanForNames(quoteRun);
                ArrayList<Pair<String, Pair>> vocativeIndices = new ArrayList<Pair<String, Pair>>();
                for (int i = 0; i < ((ArrayList)nameAndIndices.first).size(); ++i) {
                    String name = (String)((ArrayList)nameAndIndices.first).get(i);
                    Pair nameIndex = (Pair)((ArrayList)nameAndIndices.second).get(i);
                    String prevToken = ((CoreLabel)toks.get((Integer)nameIndex.first - 1)).word();
                    String prevPrevToken = ((CoreLabel)toks.get((Integer)nameIndex.first - 2)).word();
                    String nextToken = ((CoreLabel)toks.get((Integer)nameIndex.second + 1)).word();
                    if (!(prevToken.equals(",") && nextToken.equals("!") || prevToken.equals(",") && nextToken.equals("?") || prevToken.equals(",") && nextToken.equals(".") || prevToken.equals(",") && nextToken.equals(",") || prevToken.equals(",") && nextToken.equals(";") || prevToken.equals("``") && nextToken.equals(",") || nextToken.equals("''") && prevToken.equals(",") || prevToken.equalsIgnoreCase("dear")) && (!prevToken.equals("!") || !prevPrevToken.equalsIgnoreCase("oh"))) continue;
                    vocativeIndices.add(new Pair<String, Pair>(name, nameIndex));
                }
                if (vocativeIndices.size() <= 0) continue;
                VocativeSieve.fillInMention(quote, (String)((Pair)vocativeIndices.get((int)0)).first, (Integer)((Pair)((Pair)vocativeIndices.get((int)0)).second).first, (Integer)((Pair)((Pair)vocativeIndices.get((int)0)).second).second, "Deterministic Vocative -- name", "name");
                vocativeFound = true;
                break;
            }
            if (vocativeFound) continue;
            for (CoreMap prevQuote3 : quotesInPrevParagraph) {
                quoteRun = new Pair(prevQuote3.get(CoreAnnotations.TokenBeginAnnotation.class), prevQuote3.get(CoreAnnotations.TokenEndAnnotation.class));
                List<Integer> animates = this.scanForAnimates(quoteRun);
                ArrayList<Pair<String, Integer>> animateVocatives = new ArrayList<Pair<String, Integer>>();
                for (int animateIndex : animates) {
                    String prevToken = ((CoreLabel)toks.get(animateIndex - 1)).word();
                    String prevPrevToken = ((CoreLabel)toks.get(animateIndex - 2)).word();
                    String nextToken = ((CoreLabel)toks.get(animateIndex + 1)).word();
                    if (!(prevToken.equals(",") && nextToken.equals("!") || prevToken.equals(",") && nextToken.equals("?") || prevToken.equals(",") && nextToken.equals(".") || prevToken.equals(",") && nextToken.equals(",") || prevToken.equals(",") && nextToken.equals(";") || prevToken.equals("``") && nextToken.equals(",") || nextToken.equals("''") && prevToken.equals(",") || prevToken.equalsIgnoreCase("dear")) && (!prevToken.equals("!") || !prevPrevToken.equalsIgnoreCase("oh"))) continue;
                    animateVocatives.add(new Pair<String, Integer>(((CoreLabel)toks.get(animateIndex)).word(), animateIndex));
                }
                if (animateVocatives.size() <= 0) continue;
                VocativeSieve.fillInMention(quote, (String)((Pair)animateVocatives.get((int)0)).first, (Integer)((Pair)animateVocatives.get((int)0)).second, (Integer)((Pair)animateVocatives.get((int)0)).second, "Deterministic Vocative -- animate noun", "animate noun");
                continue block0;
            }
        }
    }
}

