/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.PaddedList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public abstract class FeatureFactory<IN>
implements Serializable {
    private static final long serialVersionUID = 7249250071983091694L;
    protected SeqClassifierFlags flags;
    public static final Clique cliqueC = Clique.valueOf(new int[]{0});
    public static final Clique cliqueCpC = Clique.valueOf(new int[]{-1, 0});
    public static final Clique cliqueCp2C = Clique.valueOf(new int[]{-2, 0});
    public static final Clique cliqueCp3C = Clique.valueOf(new int[]{-3, 0});
    public static final Clique cliqueCp4C = Clique.valueOf(new int[]{-4, 0});
    public static final Clique cliqueCp5C = Clique.valueOf(new int[]{-5, 0});
    public static final Clique cliqueCpCp2C = Clique.valueOf(new int[]{-2, -1, 0});
    public static final Clique cliqueCpCp2Cp3C = Clique.valueOf(new int[]{-3, -2, -1, 0});
    public static final Clique cliqueCpCp2Cp3Cp4C = Clique.valueOf(new int[]{-4, -3, -2, -1, 0});
    public static final Clique cliqueCpCp2Cp3Cp4Cp5C = Clique.valueOf(new int[]{-5, -4, -3, -2, -1, 0});
    public static final Clique cliqueCnC = Clique.valueOf(new int[]{0, 1});
    public static final Clique cliqueCpCnC = Clique.valueOf(new int[]{-1, 0, 1});
    public static final List<Clique> knownCliques = Arrays.asList(cliqueC, cliqueCpC, cliqueCp2C, cliqueCp3C, cliqueCp4C, cliqueCp5C, cliqueCpCp2C, cliqueCpCp2Cp3C, cliqueCpCp2Cp3Cp4C, cliqueCpCp2Cp3Cp4Cp5C, cliqueCnC, cliqueCpCnC);

    public void init(SeqClassifierFlags flags) {
        this.flags = flags;
    }

    public List<Clique> getCliques() {
        return FeatureFactory.getCliques(this.flags.maxLeft, this.flags.maxRight);
    }

    public static void eachClique(int left, int right, Consumer<Clique> consumer) {
        for (Clique c : knownCliques) {
            if (-c.maxLeft() != left || c.maxRight() != right) continue;
            consumer.accept(c);
        }
    }

    public static List<Clique> getCliques(int maxLeft, int maxRight) {
        ArrayList<Clique> cliques = new ArrayList<Clique>();
        for (Clique c : knownCliques) {
            if (-c.maxLeft() > maxLeft || c.maxRight() > maxRight) continue;
            cliques.add(c);
        }
        return cliques;
    }

    public abstract Collection<String> getCliqueFeatures(PaddedList<IN> var1, int var2, Clique var3);

    protected void addAllInterningAndSuffixing(Collection<String> accumulator, Collection<String> addend, String suffix) {
        boolean nonNullSuffix;
        boolean bl = nonNullSuffix = suffix != null && !suffix.isEmpty();
        if (nonNullSuffix) {
            suffix = '|' + suffix;
        }
        for (String feat : addend) {
            if (nonNullSuffix) {
                feat = feat.concat(suffix);
            }
            accumulator.add(feat);
        }
    }

    protected String getWord(CoreLabel label) {
        String word = label.getString(CoreAnnotations.TextAnnotation.class);
        if (this.flags.wordFunction != null) {
            word = this.flags.wordFunction.apply(word);
        }
        return word;
    }
}

